/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.mix.service;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.fineract.mix.data.MixTaxonomyData;
import org.apache.fineract.mix.data.MixTaxonomyMappingData;
import org.apache.fineract.mix.data.XBRLData;
import org.apache.fineract.mix.exception.XBRLMappingInvalidException;
import org.apache.fineract.mix.service.MixTaxonomyMappingReadPlatformService;
import org.apache.fineract.mix.service.MixTaxonomyReadPlatformService;
import org.apache.fineract.mix.service.XBRLResultService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class XBRLResultServiceImpl
implements XBRLResultService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XBRLResultServiceImpl.class);
    private static final ScriptEngine SCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");
    private final MixTaxonomyMappingReadPlatformService readTaxonomyMappingService;
    private final MixTaxonomyReadPlatformService readTaxonomyService;
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public XBRLResultServiceImpl(JdbcTemplate jdbcTemplate, MixTaxonomyMappingReadPlatformService readTaxonomyMappingService, MixTaxonomyReadPlatformService readTaxonomyService) {
        this.readTaxonomyMappingService = readTaxonomyMappingService;
        this.readTaxonomyService = readTaxonomyService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public XBRLData getXBRLResult(Date startDate, Date endDate, String currency) {
        HashMap config = this.retrieveTaxonomyConfig(startDate, endDate);
        if (config == null || config.size() == 0) {
            throw new XBRLMappingInvalidException("Mapping is empty");
        }
        return new XBRLData().setResultMap(config).setStartDate(startDate).setEndDate(endDate).setCurrency(currency);
    }

    private HashMap<MixTaxonomyData, BigDecimal> retrieveTaxonomyConfig(Date startDate, Date endDate) {
        MixTaxonomyMappingData taxonomyMapping = this.readTaxonomyMappingService.retrieveTaxonomyMapping();
        if (taxonomyMapping == null) {
            return null;
        }
        String config = taxonomyMapping.getConfig();
        if (config != null) {
            HashMap configMap = new HashMap();
            if ((configMap = (HashMap)new Gson().fromJson(config, configMap.getClass())) == null) {
                return null;
            }
            HashMap<MixTaxonomyData, BigDecimal> resultMap = new HashMap<MixTaxonomyData, BigDecimal>();
            Map accountBalanceMap = this.setupBalanceMap(this.getAccountSql(startDate, endDate));
            for (Map.Entry entry : configMap.entrySet()) {
                BigDecimal value = this.processMappingString(accountBalanceMap, (String)entry.getValue());
                MixTaxonomyData taxonomy = this.readTaxonomyService.retrieveOne(Long.valueOf(Long.parseLong((String)entry.getKey())));
                resultMap.put(taxonomy, value);
            }
            return resultMap;
        }
        return null;
    }

    private String getAccountSql(Date startDate, Date endDate) {
        return "select debits.glcode as 'glcode', debits.name as 'name', coalesce(debits.debitamount,0)-coalesce(credits.creditamount,0)) as 'balance' from (select acc_gl_account.gl_code as 'glcode',name,sum(amount) as 'debitamount' from acc_gl_journal_entry,acc_gl_account where acc_gl_account.id = acc_gl_journal_entry.account_id and acc_gl_journal_entry.type_enum=2 and acc_gl_journal_entry.entry_date <= " + String.valueOf(endDate) + " and acc_gl_journal_entry.entry_date > " + String.valueOf(startDate) + " group by glcode order by glcode) debits LEFT OUTER JOIN (select acc_gl_account.gl_code as 'glcode',name,sum(amount) as 'creditamount' from acc_gl_journal_entry,acc_gl_account where acc_gl_account.id = acc_gl_journal_entry.account_id and acc_gl_journal_entry.type_enum=1 and acc_gl_journal_entry.entry_date <= " + String.valueOf(endDate) + " and acc_gl_journal_entry.entry_date > " + String.valueOf(startDate) + " group by glcode order by glcode) credits on debits.glcode=credits.glcode union select credits.glcode as 'glcode', credits.name as 'name', coalesce(debits.debitamount,0)-coalesce(credits.creditamount,0)) as 'balance' from (select acc_gl_account.gl_code as 'glcode',name,sum(amount) as 'debitamount' from acc_gl_journal_entry,acc_gl_account where acc_gl_account.id = acc_gl_journal_entry.account_id and acc_gl_journal_entry.type_enum=2 and acc_gl_journal_entry.entry_date <= " + String.valueOf(endDate) + " and acc_gl_journal_entry.entry_date > " + String.valueOf(startDate) + " group by glcode order by glcode) debits RIGHT OUTER JOIN (select acc_gl_account.gl_code as 'glcode',name,sum(amount) as 'creditamount' from acc_gl_journal_entry,acc_gl_account where acc_gl_account.id = acc_gl_journal_entry.account_id and acc_gl_journal_entry.type_enum=1 and acc_gl_journal_entry.entry_date <= " + String.valueOf(endDate) + " and acc_gl_journal_entry.entry_date > " + String.valueOf(startDate) + " group by name, glcode order by glcode) credits on debits.glcode=credits.glcode;";
    }

    private Map<String, BigDecimal> setupBalanceMap(String sql) {
        HashMap<String, BigDecimal> accountBalanceMap = new HashMap<String, BigDecimal>();
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sql);
        while (rs.next()) {
            accountBalanceMap.put(rs.getString("glcode"), rs.getBigDecimal("balance"));
        }
        return accountBalanceMap;
    }

    private BigDecimal processMappingString(Map<String, BigDecimal> accountBalanceMap, String mappingString) {
        List glCodes = this.getGLCodes(mappingString);
        for (String glcode : glCodes) {
            BigDecimal balance = accountBalanceMap.get(glcode);
            mappingString = mappingString.replaceAll("\\{" + glcode + "\\}", balance != null ? balance.toString() : "0");
        }
        float eval = 0.0f;
        try {
            Number value = (Number)SCRIPT_ENGINE.eval(mappingString);
            if (value != null) {
                eval = value.floatValue();
            }
        }
        catch (ScriptException e) {
            log.error("Problem occurred in processMappingString function", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return BigDecimal.valueOf(eval);
    }

    public List<String> getGLCodes(String template) {
        ArrayList<String> placeholders = new ArrayList<String>();
        if (template != null) {
            Pattern p = Pattern.compile("\\{(.*?)\\}");
            Matcher m = p.matcher(template);
            while (m.find()) {
                String match = m.group();
                String code = match.substring(1, match.length() - 1);
                placeholders.add(code);
            }
        }
        return placeholders;
    }
}

