/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.loanrepayment;

import com.google.common.base.Splitter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoanRepaymentImportHandler
implements ImportHandler {
    public static final String SEPARATOR = "-";
    public static final String EMPTY_STR = "";
    private static final Logger LOG = LoggerFactory.getLogger(LoanRepaymentImportHandler.class);
    private final LoanReadPlatformService loanReadPlatformService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public LoanRepaymentImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, LoanReadPlatformService loanReadPlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.loanReadPlatformService = loanReadPlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List loanRepayments = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, loanRepayments, dateFormat, locale);
    }

    private List<LoanTransactionData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<LoanTransactionData> loanRepayments = new ArrayList<LoanTransactionData>();
        Sheet loanRepaymentSheet = workbook.getSheet("LoanRepayment");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)loanRepaymentSheet, (int)8);
        Long loanAccountId = null;
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = loanRepaymentSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)16)) continue;
            loanRepayments.add(this.readLoanRepayment(workbook, loanAccountId, row, locale, dateFormat));
        }
        return loanRepayments;
    }

    private LoanTransactionData readLoanRepayment(Workbook workbook, Long loanAccountId, Row row, String locale, String dateFormat) {
        String loanaccountInfo = ImportHandlerUtils.readAsString((int)3, (Row)row);
        if (loanaccountInfo != null) {
            List loanAccountAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)loanaccountInfo);
            loanAccountId = this.loanReadPlatformService.retrieveLoanIdByAccountNumber((String)loanAccountAr.get(0));
        }
        BigDecimal repaymentAmount = null;
        if (ImportHandlerUtils.readAsDouble((int)8, (Row)row) != null) {
            repaymentAmount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)8, (Row)row));
        }
        LocalDate repaymentDate = ImportHandlerUtils.readAsDate((int)9, (Row)row);
        String repaymentType = ImportHandlerUtils.readAsString((int)10, (Row)row);
        Long repaymentTypeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Extras"), (String)repaymentType);
        String accountNumber = ImportHandlerUtils.readAsString((int)11, (Row)row);
        Integer checkNumber = ImportHandlerUtils.readAsInt((int)12, (Row)row);
        Integer routingCode = ImportHandlerUtils.readAsInt((int)13, (Row)row);
        Integer receiptNumber = ImportHandlerUtils.readAsInt((int)14, (Row)row);
        Integer bankNumber = ImportHandlerUtils.readAsInt((int)15, (Row)row);
        return LoanTransactionData.importInstance((BigDecimal)repaymentAmount, (LocalDate)repaymentDate, (Long)repaymentTypeId, (String)accountNumber, (Integer)checkNumber, (Integer)routingCode, (Integer)receiptNumber, (Integer)bankNumber, (Long)loanAccountId, (String)EMPTY_STR, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<LoanTransactionData> loanRepayments, String dateFormat, String locale) {
        Sheet loanRepaymentSheet = workbook.getSheet("LoanRepayment");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, locale));
        for (LoanTransactionData loanRepayment : loanRepayments) {
            try {
                JsonObject loanRepaymentJsonob = gsonBuilder.create().toJsonTree((Object)loanRepayment).getAsJsonObject();
                loanRepaymentJsonob.remove("manuallyReversed");
                String payload = loanRepaymentJsonob.toString();
                CommandWrapper commandRequest = new CommandWrapperBuilder().loanRepaymentTransaction(loanRepayment.getAccountId()).withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = loanRepaymentSheet.getRow(loanRepayment.getRowIndex().intValue()).createCell(16);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)loanRepaymentSheet, (Integer)loanRepayment.getRowIndex(), (String)errorMessage, (int)16);
            }
        }
        loanRepaymentSheet.setColumnWidth(16, 4000);
        ImportHandlerUtils.writeString((int)16, (Row)loanRepaymentSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

