/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.io.Closeable;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.messages.MessageSink;

public abstract class DispatchedMessageSink
extends AbstractMessageSink {
    private final Executor executor;
    private volatile CompletableFuture<Void> dispatchComplete;
    private MessageSink typeSink;

    public DispatchedMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
        if (!autoDemand) {
            throw new IllegalArgumentException("%s must be auto-demanding".formatted(this.getClass().getSimpleName()));
        }
        this.executor = session.getWebSocketComponents().getExecutor();
    }

    public abstract MessageSink newMessageSink();

    @Override
    public void accept(Frame frame, Callback callback) {
        if (this.typeSink == null) {
            this.typeSink = this.newMessageSink();
            this.dispatchComplete = new CompletableFuture();
            this.executor.execute(() -> {
                try {
                    this.getMethodHandle().invoke(this.typeSink);
                    MessageSink patt0$temp = this.typeSink;
                    if (patt0$temp instanceof Closeable) {
                        Closeable closeable = (Closeable)((Object)patt0$temp);
                        IO.close(closeable);
                    }
                    this.dispatchComplete.complete(null);
                }
                catch (Throwable throwable) {
                    this.typeSink.fail(throwable);
                    this.dispatchComplete.completeExceptionally(throwable);
                }
            });
        }
        Callback frameCallback = callback;
        if (frame.isFin()) {
            Callback.Completable frameComplete = Callback.Completable.from(callback);
            frameCallback = frameComplete;
            CompletableFuture.allOf(this.dispatchComplete, frameComplete).whenComplete((result, failure) -> {
                this.typeSink = null;
                this.dispatchComplete = null;
                if (failure == null) {
                    this.autoDemand();
                } else {
                    if (failure instanceof CompletionException) {
                        CompletionException completionException = (CompletionException)failure;
                        failure = completionException.getCause();
                    }
                    CloseStatus closeStatus = new CloseStatus(1011, (Throwable)failure);
                    this.getCoreSession().close(closeStatus, Callback.NOOP);
                }
            });
        }
        this.typeSink.accept(frame, frameCallback);
    }

    @Override
    public void fail(Throwable failure) {
        if (this.typeSink != null) {
            this.typeSink.fail(failure);
        }
    }

    public boolean isDispatched() {
        return this.dispatchComplete != null;
    }
}

