/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBVarArgsFuncExpr
extends DBColumnExpr {
    private DBDatabase database;
    private DataType dataType;
    private String template;
    private DBColumnExpr[] cols;

    public DBVarArgsFuncExpr(DBDatabase db, DataType dataType, String template, DBColumnExpr ... cols) {
        if (template.indexOf("?") < 0) {
            throw new InvalidArgumentException("template", template);
        }
        this.database = db;
        this.dataType = dataType;
        this.template = template;
        this.cols = cols;
    }

    public final DBDatabase getDatabase() {
        return this.database;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        return DBVarArgsFuncExpr.getNameFromTemplate(this.template);
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBVarArgsFuncExpr) {
            DBVarArgsFuncExpr otherFunc = (DBVarArgsFuncExpr)other;
            if (!this.dataType.equals((Object)otherFunc.dataType)) {
                return false;
            }
            if (!StringUtils.compareEqual(this.template, otherFunc.template)) {
                return false;
            }
            for (int i = 0; i < this.cols.length; ++i) {
                if (this.cols[i].equals(otherFunc.cols[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public DBRowSet getRowSet() {
        return this.cols[0].getRowSet();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        for (int i = 0; i < this.cols.length; ++i) {
            DBColumn col = this.cols[i].getUpdateColumn();
            if (col == null) continue;
            list.add(col);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        String prefix = this.template;
        String suffix = "";
        int sep = this.template.indexOf("?");
        if (sep >= 0) {
            prefix = this.template.substring(0, sep);
            suffix = this.template.substring(sep + 1);
        }
        sql.append(prefix);
        for (int i = 0; i < this.cols.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            DBColumnExpr col = this.cols[i];
            col.addSQL(sql, 7L);
        }
        sql.append(suffix);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        elem.setAttribute("function", this.getName());
        return elem;
    }

    private static String getNameFromTemplate(String template) {
        int i;
        String s = template.trim();
        for (i = 0; i < s.length() && s.charAt(i) >= 'A'; ++i) {
        }
        if (i > 0) {
            return s.substring(0, i);
        }
        return "unknownFunc";
    }
}

