/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateStoreImageTaskRequest;
import com.amazonaws.services.ec2.model.S3ObjectTag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateStoreImageTaskRequestMarshaller
implements Marshaller<Request<CreateStoreImageTaskRequest>, CreateStoreImageTaskRequest> {
    public Request<CreateStoreImageTaskRequest> marshall(CreateStoreImageTaskRequest createStoreImageTaskRequest) {
        SdkInternalList createStoreImageTaskRequestS3ObjectTagsList;
        if (createStoreImageTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStoreImageTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateStoreImageTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStoreImageTaskRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)createStoreImageTaskRequest.getImageId()));
        }
        if (createStoreImageTaskRequest.getBucket() != null) {
            request.addParameter("Bucket", StringUtils.fromString((String)createStoreImageTaskRequest.getBucket()));
        }
        if (!(createStoreImageTaskRequestS3ObjectTagsList = (SdkInternalList)createStoreImageTaskRequest.getS3ObjectTags()).isEmpty() || !createStoreImageTaskRequestS3ObjectTagsList.isAutoConstruct()) {
            int s3ObjectTagsListIndex = 1;
            for (S3ObjectTag createStoreImageTaskRequestS3ObjectTagsListValue : createStoreImageTaskRequestS3ObjectTagsList) {
                if (createStoreImageTaskRequestS3ObjectTagsListValue.getKey() != null) {
                    request.addParameter("S3ObjectTag." + s3ObjectTagsListIndex + ".Key", StringUtils.fromString((String)createStoreImageTaskRequestS3ObjectTagsListValue.getKey()));
                }
                if (createStoreImageTaskRequestS3ObjectTagsListValue.getValue() != null) {
                    request.addParameter("S3ObjectTag." + s3ObjectTagsListIndex + ".Value", StringUtils.fromString((String)createStoreImageTaskRequestS3ObjectTagsListValue.getValue()));
                }
                ++s3ObjectTagsListIndex;
            }
        }
        return request;
    }
}

