/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AllocateAddressRequestMarshaller
implements Marshaller<Request<AllocateAddressRequest>, AllocateAddressRequest> {
    public Request<AllocateAddressRequest> marshall(AllocateAddressRequest allocateAddressRequest) {
        SdkInternalList allocateAddressRequestTagSpecificationsList;
        if (allocateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateAddressRequest, "AmazonEC2");
        request.addParameter("Action", "AllocateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateAddressRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)allocateAddressRequest.getDomain()));
        }
        if (allocateAddressRequest.getAddress() != null) {
            request.addParameter("Address", StringUtils.fromString((String)allocateAddressRequest.getAddress()));
        }
        if (allocateAddressRequest.getPublicIpv4Pool() != null) {
            request.addParameter("PublicIpv4Pool", StringUtils.fromString((String)allocateAddressRequest.getPublicIpv4Pool()));
        }
        if (allocateAddressRequest.getNetworkBorderGroup() != null) {
            request.addParameter("NetworkBorderGroup", StringUtils.fromString((String)allocateAddressRequest.getNetworkBorderGroup()));
        }
        if (allocateAddressRequest.getCustomerOwnedIpv4Pool() != null) {
            request.addParameter("CustomerOwnedIpv4Pool", StringUtils.fromString((String)allocateAddressRequest.getCustomerOwnedIpv4Pool()));
        }
        if (!(allocateAddressRequestTagSpecificationsList = (SdkInternalList)allocateAddressRequest.getTagSpecifications()).isEmpty() || !allocateAddressRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification allocateAddressRequestTagSpecificationsListValue : allocateAddressRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (allocateAddressRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)allocateAddressRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)allocateAddressRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

