/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class PossiblyNullColumnValueSelector<T>
implements ColumnValueSelector<T> {
    private final ColumnValueSelector<T> baseSelector;
    private final BooleanSupplier beNull;

    PossiblyNullColumnValueSelector(ColumnValueSelector<T> baseSelector, BooleanSupplier beNull) {
        this.baseSelector = baseSelector;
        this.beNull = beNull;
    }

    @Override
    public double getDouble() {
        return this.beNull.getAsBoolean() ? 0.0 : this.baseSelector.getDouble();
    }

    @Override
    public float getFloat() {
        return this.beNull.getAsBoolean() ? 0.0f : this.baseSelector.getFloat();
    }

    @Override
    public long getLong() {
        return this.beNull.getAsBoolean() ? 0L : this.baseSelector.getLong();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        this.baseSelector.inspectRuntimeShape(inspector);
        inspector.visit("beNull", this.beNull);
    }

    @Override
    @Nullable
    public T getObject() {
        return this.beNull.getAsBoolean() ? null : (T)this.baseSelector.getObject();
    }

    @Override
    public Class<? extends T> classOfObject() {
        return this.baseSelector.classOfObject();
    }

    @Override
    public boolean isNull() {
        return this.beNull.getAsBoolean() || this.baseSelector.isNull();
    }
}

