/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.CgroupUtil;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Cpu;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupV2CpuMonitor
extends FeedDefiningMonitor {
    private static final String SNAPSHOT = "snapshot";
    final CgroupDiscoverer cgroupDiscoverer;
    private final KeyedDiff diff = new KeyedDiff();

    public CgroupV2CpuMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    @VisibleForTesting
    CgroupV2CpuMonitor(CgroupDiscoverer cgroupDiscoverer) {
        this(cgroupDiscoverer, "metrics");
    }

    CgroupV2CpuMonitor() {
        this(new ProcSelfCgroupDiscoverer(ProcCgroupV2Discoverer.class));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = this.builder();
        builder.setDimension("cgroupversion", this.cgroupDiscoverer.getCgroupVersion().name());
        Cpu.CpuMetrics cpuSnapshot = this.cgroupDiscoverer.getCpuMetrics();
        emitter.emit(builder.setMetric("cgroup/cpu/shares", cpuSnapshot.getShares()));
        emitter.emit(builder.setMetric("cgroup/cpu/cores_quota", CgroupUtil.computeProcessorQuota(cpuSnapshot.getQuotaUs(), cpuSnapshot.getPeriodUs())));
        Map<String, Long> elapsed = this.diff.to("usage", (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)cpuSnapshot.getUserUs()).put((Object)"system", (Object)cpuSnapshot.getSystemUs()).put((Object)"total", (Object)cpuSnapshot.getTotalUs()).put((Object)SNAPSHOT, (Object)ChronoUnit.MICROS.between(Instant.EPOCH, Instant.now())).build());
        if (elapsed != null) {
            long elapsedUsecs = elapsed.get(SNAPSHOT);
            double totalUsagePct = 100.0 * (double)elapsed.get("total").longValue() / (double)elapsedUsecs;
            double sysUsagePct = 100.0 * (double)elapsed.get("system").longValue() / (double)elapsedUsecs;
            double userUsagePct = 100.0 * (double)elapsed.get("user").longValue() / (double)elapsedUsecs;
            emitter.emit(builder.setMetric("cgroup/cpu/usage/total/percentage", totalUsagePct));
            emitter.emit(builder.setMetric("cgroup/cpu/usage/sys/percentage", sysUsagePct));
            emitter.emit(builder.setMetric("cgroup/cpu/usage/user/percentage", userUsagePct));
        }
        return true;
    }
}

