/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.druid.java.util.common.guava.Yielder;

public class ExecuteWhenDoneYielder<T>
implements Yielder<T> {
    private final Yielder<T> baseYielder;
    private final Runnable runnable;
    private final Executor executor;

    public ExecuteWhenDoneYielder(Yielder<T> baseYielder, Runnable runnable, Executor executor) {
        this.baseYielder = baseYielder;
        this.runnable = runnable;
        this.executor = executor;
    }

    @Override
    public T get() {
        return this.baseYielder.get();
    }

    @Override
    public Yielder<T> next(T initValue) {
        return new ExecuteWhenDoneYielder<T>(this.baseYielder.next(initValue), this.runnable, this.executor);
    }

    @Override
    public boolean isDone() {
        return this.baseYielder.isDone();
    }

    @Override
    public void close() throws IOException {
        boolean done = this.isDone();
        Throwable thrown = null;
        try {
            this.baseYielder.close();
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            if (done) {
                if (thrown != null) {
                    try {
                        this.executor.execute(this.runnable);
                    }
                    catch (Throwable t) {
                        thrown.addSuppressed(t);
                    }
                } else {
                    this.executor.execute(this.runnable);
                }
            }
        }
    }
}

