/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.processor.FrameChannelBatcher;
import org.apache.druid.frame.processor.FrameChannelMerger;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorDecorator;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CloseableUtils;

public class SuperSorter {
    private static final Logger log = new Logger(SuperSorter.class);
    public static final long UNLIMITED = -1L;
    public static final int UNKNOWN_LEVEL = -1;
    public static final long UNKNOWN_TOTAL = -1L;
    private final List<ReadableFrameChannel> inputChannels;
    private final FrameReader frameReader;
    private final List<KeyColumn> sortKey;
    private final ListenableFuture<ClusterByPartitions> outputPartitionsFuture;
    private final FrameProcessorExecutor exec;
    private final FrameProcessorDecorator processorDecorator;
    private final OutputChannelFactory outputChannelFactory;
    private final OutputChannelFactory intermediateOutputChannelFactory;
    private final FrameType outputFrameType;
    private final int maxChannelsPerMerger;
    private final int maxActiveProcessors;
    private final String cancellationId;
    private final boolean removeNullBytes;
    private final Object runWorkersLock = new Object();
    @GuardedBy(value="runWorkersLock")
    private boolean batcherIsRunning = false;
    @GuardedBy(value="runWorkersLock")
    private IntSet inputChannelsToRead = new IntOpenHashSet();
    @GuardedBy(value="runWorkersLock")
    private final Int2ObjectMap<LongSortedSet> outputsReadyByLevel = new Int2ObjectArrayMap();
    @GuardedBy(value="runWorkersLock")
    private List<OutputChannel> outputChannels = null;
    @GuardedBy(value="runWorkersLock")
    private final Map<String, PartitionedOutputChannel> levelAndRankToReadableChannelMap = new HashMap<String, PartitionedOutputChannel>();
    @GuardedBy(value="runWorkersLock")
    private int activeProcessors = 0;
    @GuardedBy(value="runWorkersLock")
    private long totalInputFrames = -1L;
    @GuardedBy(value="runWorkersLock")
    private int totalMergingLevels = -1;
    @GuardedBy(value="runWorkersLock")
    private final Queue<Frame> inputBuffer = new ArrayDeque<Frame>();
    @GuardedBy(value="runWorkersLock")
    private long inputFramesReadSoFar = 0L;
    @GuardedBy(value="runWorkersLock")
    private long levelZeroMergersRunSoFar = 0L;
    @GuardedBy(value="runWorkersLock")
    private int ultimateMergersRunSoFar = 0;
    @GuardedBy(value="runWorkersLock")
    private SettableFuture<OutputChannels> allDone = null;
    @GuardedBy(value="runWorkersLock")
    SuperSorterProgressTracker superSorterProgressTracker;
    @GuardedBy(value="runWorkersLock")
    private long rowLimit;
    @GuardedBy(value="runWorkersLock")
    private Runnable noWorkRunnable = null;

    public SuperSorter(List<ReadableFrameChannel> inputChannels, FrameReader frameReader, List<KeyColumn> sortKey, ListenableFuture<ClusterByPartitions> outputPartitionsFuture, FrameProcessorExecutor exec, FrameProcessorDecorator processorDecorator, OutputChannelFactory outputChannelFactory, OutputChannelFactory intermediateOutputChannelFactory, FrameType outputFrameType, int maxActiveProcessors, int maxChannelsPerMerger, long rowLimit, @Nullable String cancellationId, SuperSorterProgressTracker superSorterProgressTracker, boolean removeNullBytes) {
        this.inputChannels = inputChannels;
        this.frameReader = frameReader;
        this.sortKey = sortKey;
        this.outputPartitionsFuture = outputPartitionsFuture;
        this.exec = exec;
        this.processorDecorator = processorDecorator;
        this.outputChannelFactory = outputChannelFactory;
        this.intermediateOutputChannelFactory = intermediateOutputChannelFactory;
        this.outputFrameType = outputFrameType;
        this.maxChannelsPerMerger = maxChannelsPerMerger;
        this.maxActiveProcessors = maxActiveProcessors;
        this.rowLimit = rowLimit;
        this.cancellationId = cancellationId;
        this.superSorterProgressTracker = superSorterProgressTracker;
        this.removeNullBytes = removeNullBytes;
        for (int i = 0; i < inputChannels.size(); ++i) {
            this.inputChannelsToRead.add(i);
        }
        if (maxActiveProcessors < 1) {
            throw new IAE("maxActiveProcessors[%d] < 1", maxActiveProcessors);
        }
        if (maxChannelsPerMerger < 2) {
            throw new IAE("maxChannelsPerMerger[%d] < 2", maxChannelsPerMerger);
        }
        if (rowLimit != -1L && rowLimit <= 0L) {
            throw new IAE("rowLimit[%d] must be positive", rowLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<OutputChannels> run() {
        Object object = this.runWorkersLock;
        synchronized (object) {
            if (this.allDone != null) {
                throw new ISE("Cannot run() more than once.", new Object[0]);
            }
            this.allDone = SettableFuture.create();
            this.runWorkersIfPossible();
            this.outputPartitionsFuture.addListener(() -> {
                Object object = this.runWorkersLock;
                synchronized (object) {
                    if (this.outputPartitionsFuture.isDone()) {
                        this.superSorterProgressTracker.setTotalMergersForUltimateLevel(this.getOutputPartitions().size());
                    }
                    this.runWorkersIfPossible();
                    this.setAllDoneIfPossible();
                }
            }, this.exec.asExecutor(this.cancellationId));
            return FutureUtils.futureWithBaggage(this.allDone, () -> {
                Object object = this.runWorkersLock;
                synchronized (object) {
                    if (this.activeProcessors == 0) {
                        this.cleanUp();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setNoWorkRunnable(Runnable runnable) {
        Object object = this.runWorkersLock;
        synchronized (object) {
            this.noWorkRunnable = runnable;
        }
    }

    @GuardedBy(value="runWorkersLock")
    private void workerFinished() {
        --this.activeProcessors;
        if (log.isDebugEnabled()) {
            log.debug(this.stateString(), new Object[0]);
        }
        this.runWorkersIfPossible();
        this.setAllDoneIfPossible();
        if (this.isAllDone() && this.activeProcessors == 0) {
            this.cleanUp();
        }
    }

    @GuardedBy(value="runWorkersLock")
    private void runWorkersIfPossible() {
        if (this.isAllDone()) {
            return;
        }
        this.setTotalMergingLevelsIfPossible();
        try {
            while (this.activeProcessors < this.maxActiveProcessors && (this.runNextDirectMerger() || this.runNextUltimateMerger() || this.runNextMiddleMerger() || this.runNextLevelZeroMerger() || this.runNextBatcher())) {
                ++this.activeProcessors;
                if (!log.isDebugEnabled()) continue;
                log.debug(this.stateString(), new Object[0]);
            }
            if (this.activeProcessors == 0 && this.noWorkRunnable != null) {
                log.debug("No active workers and no work left to start.", new Object[0]);
                this.noWorkRunnable.run();
            }
        }
        catch (Throwable e) {
            this.allDone.setException(e);
        }
    }

    @GuardedBy(value="runWorkersLock")
    private void setAllDoneIfPossible() {
        if (this.isAllDone()) {
            return;
        }
        try {
            if (this.totalInputFrames == 0L && this.outputPartitionsFuture.isDone()) {
                ClusterByPartitions partitions = this.getOutputPartitions();
                ArrayList<OutputChannel> channels = new ArrayList<OutputChannel>(partitions.size());
                for (int partitionNum = 0; partitionNum < partitions.size(); ++partitionNum) {
                    channels.add(this.outputChannelFactory.openNilChannel(partitionNum));
                }
                this.allDone.set((Object)OutputChannels.wrap(channels));
            } else if (this.rowLimit == 0L && this.activeProcessors == 0) {
                for (int partitionNum = 0; partitionNum < this.outputChannels.size(); ++partitionNum) {
                    if (this.outputChannels.get(partitionNum) != null) continue;
                    this.outputChannels.set(partitionNum, this.outputChannelFactory.openNilChannel(partitionNum));
                    this.superSorterProgressTracker.addMergedBatchesForLevel(this.totalMergingLevels - 1, 1L);
                }
                this.allDone.set((Object)OutputChannels.wrap(this.outputChannels));
            } else if (this.totalMergingLevels != -1 && this.outputsReadyByLevel.containsKey(this.totalMergingLevels - 1) && (long)((LongSortedSet)this.outputsReadyByLevel.get(this.totalMergingLevels - 1)).size() == this.getTotalMergersInLevel(this.totalMergingLevels - 1)) {
                this.allDone.set((Object)OutputChannels.wrap(this.outputChannels));
            }
        }
        catch (Throwable e) {
            this.allDone.setException(e);
        }
    }

    @GuardedBy(value="runWorkersLock")
    private boolean runNextBatcher() {
        if (this.batcherIsRunning || this.inputChannelsToRead.isEmpty()) {
            return false;
        }
        this.batcherIsRunning = true;
        this.runWorker(new FrameChannelBatcher(this.inputChannels, this.maxChannelsPerMerger), result -> {
            List batch = (List)result.lhs;
            IntSet keepReading = (IntSet)result.rhs;
            Object object = this.runWorkersLock;
            synchronized (object) {
                this.inputBuffer.addAll(batch);
                this.inputFramesReadSoFar += (long)batch.size();
                this.inputChannelsToRead = keepReading;
                if (this.inputChannelsToRead.isEmpty()) {
                    this.inputChannels.forEach(ReadableFrameChannel::close);
                    this.setTotalInputFrames(this.inputFramesReadSoFar);
                    this.setTotalMergingLevelsIfPossible();
                    this.runWorkersIfPossible();
                } else if (this.inputBuffer.size() >= this.maxChannelsPerMerger) {
                    this.runWorkersIfPossible();
                }
                this.batcherIsRunning = false;
            }
        });
        return true;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean runNextDirectMerger() {
        if (this.totalMergingLevels != 1 || !this.allInputRead() || (long)this.ultimateMergersRunSoFar >= this.getTotalMergersInLevel(0)) {
            return false;
        }
        if (this.isLimited() && (this.rowLimit == 0L || this.activeProcessors > 0)) {
            return false;
        }
        ArrayList<ReadableFrameChannel> in = new ArrayList<ReadableFrameChannel>();
        for (Frame frame : this.inputBuffer) {
            in.add(SuperSorter.singleReadableFrameChannel(new FrameWithPartition(frame, -1)));
        }
        this.runMerger(0, this.ultimateMergersRunSoFar++, in, Collections.emptyList());
        return true;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean runNextLevelZeroMerger() {
        Frame frame;
        if (this.totalMergingLevels == 1) {
            return false;
        }
        if (this.inputBuffer.isEmpty()) {
            return false;
        }
        if (this.totalMergingLevels == -1 && this.inputBuffer.size() < this.getMaxInputBufferFramesForDirectMerging()) {
            return false;
        }
        ArrayList<ReadableFrameChannel> in = new ArrayList<ReadableFrameChannel>();
        while (in.size() < this.maxChannelsPerMerger && (frame = this.inputBuffer.poll()) != null) {
            in.add(SuperSorter.singleReadableFrameChannel(new FrameWithPartition(frame, -1)));
        }
        this.runMerger(0, this.levelZeroMergersRunSoFar++, in, (List<PartitionedReadableFrameChannel>)ImmutableList.of());
        return true;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean runNextMiddleMerger() {
        for (int inLevel = this.outputsReadyByLevel.size() - 1; inLevel >= 0; --inLevel) {
            int channelsPerMerger;
            int outLevel = inLevel + 1;
            long totalInputs = this.getTotalMergersInLevel(inLevel);
            LongSortedSet inputsReady = (LongSortedSet)this.outputsReadyByLevel.get(inLevel);
            if (this.totalMergingLevels != -1 && outLevel >= this.totalMergingLevels - 1 || this.totalMergingLevels == -1 && LongMath.divide((long)inputsReady.size(), (long)this.maxChannelsPerMerger, (RoundingMode)RoundingMode.CEILING) <= (long)this.maxChannelsPerMerger) continue;
            if (this.totalMergingLevels != -1 && outLevel == this.totalMergingLevels - 2) {
                if (!this.outputPartitionsFuture.isDone()) continue;
                channelsPerMerger = Ints.checkedCast((long)LongMath.divide((long)totalInputs, (long)this.getTotalMergersInLevel(outLevel), (RoundingMode)RoundingMode.CEILING));
            } else {
                channelsPerMerger = this.maxChannelsPerMerger;
            }
            LongBidirectionalIterator iter = inputsReady.iterator();
            long currentSetStart = -1L;
            long currentSetIndex = -1L;
            while (iter.hasNext()) {
                long w = iter.nextLong();
                if (w % (long)channelsPerMerger == 0L) {
                    currentSetStart = w;
                    currentSetIndex = -1L;
                }
                if (currentSetStart < 0L) continue;
                long pos = w - currentSetStart;
                if (pos == currentSetIndex + 1L && (pos == (long)(channelsPerMerger - 1) || totalInputs != -1L && w == totalInputs - 1L)) {
                    ArrayList<ReadableFrameChannel> in = new ArrayList<ReadableFrameChannel>();
                    ArrayList<PartitionedReadableFrameChannel> partitionedReadableFrameChannels = new ArrayList<PartitionedReadableFrameChannel>();
                    for (long i = currentSetStart; i < currentSetStart + (long)channelsPerMerger; ++i) {
                        if (!inputsReady.remove(i)) continue;
                        String levelAndRankKey = this.mergerOutputFileName(inLevel, i);
                        PartitionedReadableFrameChannel partitionedReadableFrameChannel = this.levelAndRankToReadableChannelMap.remove(levelAndRankKey).getReadableChannelSupplier().get();
                        in.add(partitionedReadableFrameChannel.getReadableFrameChannel(0));
                        partitionedReadableFrameChannels.add(partitionedReadableFrameChannel);
                    }
                    this.runMerger(outLevel, currentSetStart / (long)channelsPerMerger, in, partitionedReadableFrameChannels);
                    return true;
                }
                if (w == currentSetStart + currentSetIndex + 1L) {
                    ++currentSetIndex;
                    continue;
                }
                currentSetStart = -1L;
                currentSetIndex = -1L;
            }
        }
        return false;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean runNextUltimateMerger() {
        if (this.totalMergingLevels == -1 || this.totalMergingLevels < 2 || !this.outputPartitionsFuture.isDone() || this.ultimateMergersRunSoFar >= this.getOutputPartitions().size()) {
            return false;
        }
        if (this.isLimited() && (this.rowLimit == 0L || this.activeProcessors > 0)) {
            return false;
        }
        int inLevel = this.totalMergingLevels - 2;
        int outLevel = inLevel + 1;
        LongSortedSet inputsReady = (LongSortedSet)this.outputsReadyByLevel.get(inLevel);
        if (inputsReady == null) {
            return false;
        }
        int numInputs = inputsReady.size();
        if ((long)numInputs != this.getTotalMergersInLevel(inLevel)) {
            return false;
        }
        ArrayList<ReadableFrameChannel> in = new ArrayList<ReadableFrameChannel>(numInputs);
        for (long i = 0L; i < (long)numInputs; ++i) {
            in.add(this.levelAndRankToReadableChannelMap.get(this.mergerOutputFileName(inLevel, i)).getReadableChannelSupplier().get().getReadableFrameChannel(this.ultimateMergersRunSoFar));
        }
        this.runMerger(outLevel, this.ultimateMergersRunSoFar++, in, (List<PartitionedReadableFrameChannel>)ImmutableList.of());
        return true;
    }

    @GuardedBy(value="runWorkersLock")
    private void runMerger(int level, long rank, List<ReadableFrameChannel> in, List<PartitionedReadableFrameChannel> partitionedReadableChannelsToClose) {
        try {
            ClusterByPartitions outPartitions;
            SingleMemoryAllocatorFactory frameAllocatorFactory;
            WritableFrameChannel writableChannel;
            boolean isFinalOutput;
            String levelAndRankKey = this.mergerOutputFileName(level, rank);
            boolean bl = isFinalOutput = this.totalMergingLevels != -1 && level == this.totalMergingLevels - 1;
            if (isFinalOutput) {
                int outputPartitionCount = this.getOutputPartitions().size();
                int intRank = Ints.checkedCast((long)rank);
                if (this.outputChannels == null) {
                    this.outputChannels = Arrays.asList(new OutputChannel[outputPartitionCount]);
                }
                OutputChannel outputChannel = this.outputChannelFactory.openChannel(intRank);
                writableChannel = outputChannel.getWritableChannel();
                frameAllocatorFactory = new SingleMemoryAllocatorFactory(outputChannel.getFrameMemoryAllocator());
                this.outputChannels.set(intRank, outputChannel.readOnly());
                outPartitions = this.totalMergingLevels == 1 ? new ClusterByPartitions(Collections.singletonList(this.getOutputPartitions().get(intRank))) : null;
            } else {
                PartitionedOutputChannel partitionedOutputChannel = this.intermediateOutputChannelFactory.openPartitionedChannel(levelAndRankKey, true);
                writableChannel = partitionedOutputChannel.getWritableChannel();
                frameAllocatorFactory = new SingleMemoryAllocatorFactory(partitionedOutputChannel.getFrameMemoryAllocator());
                outPartitions = level == this.totalMergingLevels - 2 ? this.getOutputPartitions() : null;
                this.levelAndRankToReadableChannelMap.put(levelAndRankKey, partitionedOutputChannel.readOnly());
            }
            FrameChannelMerger worker = new FrameChannelMerger(in, this.frameReader, writableChannel, FrameWriters.makeFrameWriterFactory(this.outputFrameType, frameAllocatorFactory, this.frameReader.signature(), Collections.emptyList(), this.removeNullBytes), this.sortKey, outPartitions, this.rowLimit);
            this.runWorker(worker, outputRows -> {
                Object object = this.runWorkersLock;
                synchronized (object) {
                    ((LongSortedSet)this.outputsReadyByLevel.computeIfAbsent(level, ignored2 -> new LongRBTreeSet())).add(rank);
                    this.superSorterProgressTracker.addMergedBatchesForLevel(level, 1L);
                    if (this.isLimited() && this.totalMergingLevels != -1 && level == this.totalMergingLevels - 1) {
                        this.rowLimit -= outputRows.longValue();
                        if (this.rowLimit < 0L) {
                            throw DruidException.defensive("rowLimit[%d] below zero after outputRows[%d]", this.rowLimit, outputRows);
                        }
                    }
                    for (PartitionedReadableFrameChannel partitionedReadableFrameChannel : partitionedReadableChannelsToClose) {
                        try {
                            partitionedReadableFrameChannel.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(StringUtils.format("Could not close channel for level [%d] and rank [%d]", level, rank), e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void runWorker(FrameProcessor<T> worker, final Consumer<T> outConsumer) {
        Futures.addCallback(this.exec.runFully(this.processorDecorator.decorate(worker), this.cancellationId), (FutureCallback)new FutureCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T result) {
                try {
                    outConsumer.accept(result);
                    Object object = SuperSorter.this.runWorkersLock;
                    synchronized (object) {
                        SuperSorter.this.workerFinished();
                    }
                }
                catch (Throwable e) {
                    Object object = SuperSorter.this.runWorkersLock;
                    synchronized (object) {
                        SuperSorter.this.allDone.setException(e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                Object object = SuperSorter.this.runWorkersLock;
                synchronized (object) {
                    SuperSorter.this.allDone.setException(t);
                }
            }
        }, (Executor)this.exec.asExecutor(this.cancellationId));
    }

    @GuardedBy(value="runWorkersLock")
    private void setTotalInputFrames(long totalInputFrames) {
        if (this.totalInputFrames != -1L) {
            throw DruidException.defensive("Cannot set totalInputFrames twice (first[%s], second[%s])", this.totalInputFrames, totalInputFrames);
        }
        this.totalInputFrames = totalInputFrames;
        if (totalInputFrames == 0L) {
            this.superSorterProgressTracker.markTriviallyComplete();
        }
    }

    @GuardedBy(value="runWorkersLock")
    private void setTotalMergingLevelsIfPossible() {
        if (this.totalMergingLevels != -1 || this.totalInputFrames == -1L || !this.outputPartitionsFuture.isDone()) {
            return;
        }
        if (this.levelZeroMergersRunSoFar == 0L) {
            this.totalMergingLevels = 1;
            this.superSorterProgressTracker.setTotalMergingLevels(1);
            this.superSorterProgressTracker.setTotalMergersForLevel(0, this.getOutputPartitions().size());
            return;
        }
        int level = 0;
        long inputsForLevel = this.totalInputFrames;
        while (inputsForLevel > (long)this.maxChannelsPerMerger) {
            long totalMergersInLevel = LongMath.divide((long)inputsForLevel, (long)this.maxChannelsPerMerger, (RoundingMode)RoundingMode.CEILING);
            this.superSorterProgressTracker.setTotalMergersForLevel(level, totalMergersInLevel);
            ++level;
            inputsForLevel = totalMergersInLevel;
        }
        this.totalMergingLevels = level <= 1 ? (this.getOutputPartitions().size() > 1 ? 3 : 2) : level + 1;
        for (int i = level; i < this.totalMergingLevels; ++i) {
            this.superSorterProgressTracker.setTotalMergersForLevel(i, 1L);
        }
        this.superSorterProgressTracker.setTotalMergingLevels(this.totalMergingLevels);
    }

    private ClusterByPartitions getOutputPartitions() {
        if (!this.outputPartitionsFuture.isDone()) {
            throw new ISE("Output partitions are not ready yet", new Object[0]);
        }
        return FutureUtils.getUnchecked(this.outputPartitionsFuture, true);
    }

    @GuardedBy(value="runWorkersLock")
    private long getTotalMergersInLevel(int level) {
        if (this.totalInputFrames == -1L || this.totalMergingLevels == -1) {
            return -1L;
        }
        if (level >= this.totalMergingLevels) {
            throw new ISE("Invalid level %d", level);
        }
        if (level == this.totalMergingLevels - 1) {
            if (this.outputPartitionsFuture.isDone()) {
                return this.totalInputFrames == 0L ? 0L : (long)this.getOutputPartitions().size();
            }
            return -1L;
        }
        if (level > 0 && level == this.totalMergingLevels - 2) {
            if (this.outputPartitionsFuture.isDone()) {
                long totalInputs = this.getTotalMergersInLevel(level - 1);
                long minMergers = LongMath.divide((long)totalInputs, (long)this.maxChannelsPerMerger, (RoundingMode)RoundingMode.CEILING);
                long targetNumMergers = Math.max(minMergers, (long)Math.min(this.maxActiveProcessors, this.getOutputPartitions().size()));
                return LongMath.divide((long)totalInputs, (long)LongMath.divide((long)totalInputs, (long)targetNumMergers, (RoundingMode)RoundingMode.CEILING), (RoundingMode)RoundingMode.CEILING);
            }
            return -1L;
        }
        long totalMergersInLevel = this.totalInputFrames;
        for (int i = 0; i <= level; ++i) {
            totalMergersInLevel = LongMath.divide((long)totalMergersInLevel, (long)this.maxChannelsPerMerger, (RoundingMode)RoundingMode.CEILING);
        }
        return totalMergersInLevel;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean allInputRead() {
        return this.totalInputFrames != -1L;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean isAllDone() {
        return this.allDone.isDone() || this.allDone.isCancelled();
    }

    @GuardedBy(value="runWorkersLock")
    private void cleanUp() {
        if (!this.isAllDone() || this.activeProcessors != 0) {
            throw new ISE("Improper cleanup", new Object[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.stateString(), new Object[0]);
        }
        this.outputsReadyByLevel.clear();
        this.inputBuffer.clear();
        for (Map.Entry<String, PartitionedOutputChannel> cleanupEntry : this.levelAndRankToReadableChannelMap.entrySet()) {
            try {
                cleanupEntry.getValue().getReadableChannelSupplier().get().close();
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Unable to close channel for name : " + cleanupEntry.getKey(), e2);
            }
        }
        this.levelAndRankToReadableChannelMap.clear();
        if (!this.inputChannelsToRead.isEmpty()) {
            for (ReadableFrameChannel inputChannel : this.inputChannels) {
                CloseableUtils.closeAndSuppressExceptions(inputChannel::close, e -> log.warn((Throwable)e, "Could not close input channel", new Object[0]));
            }
            this.inputChannels.forEach(ReadableFrameChannel::close);
        }
        this.inputChannelsToRead.clear();
    }

    private String mergerOutputFileName(int level, long rank) {
        return StringUtils.format("merged.%d.%d", level, rank);
    }

    private int getMaxInputBufferFramesForDirectMerging() {
        return this.maxChannelsPerMerger * this.maxActiveProcessors;
    }

    @GuardedBy(value="runWorkersLock")
    private boolean isLimited() {
        return this.rowLimit != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stateString() {
        Object object = this.runWorkersLock;
        synchronized (object) {
            return "frames-in=" + this.inputFramesReadSoFar + "/" + this.totalInputFrames + " frames-buffered=" + this.inputBuffer.size() + " lvls=" + this.totalMergingLevels + " parts=" + (this.outputPartitionsFuture.isDone() ? FutureUtils.getUncheckedImmediately(this.outputPartitionsFuture).size() : -1) + " p=" + this.activeProcessors + "/" + this.maxActiveProcessors + " ch-pending=" + String.valueOf(this.inputChannelsToRead) + " to-merge=" + String.valueOf(this.outputsReadyByLevel) + " done=" + (this.isAllDone() ? "y" : "n");
        }
    }

    private static ReadableFrameChannel singleReadableFrameChannel(FrameWithPartition frame) {
        try {
            BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
            channel.writable().write(frame);
            channel.writable().close();
            return channel.readable();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

