/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.taskadapter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ForkingTaskRunner;
import org.apache.druid.indexing.overlord.QuotableWhiteSpaceSplitter;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.common.Base64Compression;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.PeonCommandContext;
import org.apache.druid.k8s.overlord.taskadapter.TaskAdapter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.TaskLogs;

public abstract class K8sTaskAdapter
implements TaskAdapter {
    private static final EmittingLogger log = new EmittingLogger(K8sTaskAdapter.class);
    protected final KubernetesClientApi client;
    protected final KubernetesTaskRunnerConfig taskRunnerConfig;
    protected final TaskConfig taskConfig;
    protected final StartupLoggingConfig startupLoggingConfig;
    protected final DruidNode node;
    protected final ObjectMapper mapper;
    protected final TaskLogs taskLogs;

    public K8sTaskAdapter(KubernetesClientApi client, KubernetesTaskRunnerConfig taskRunnerConfig, TaskConfig taskConfig, StartupLoggingConfig startupLoggingConfig, DruidNode node, ObjectMapper mapper, TaskLogs taskLogs) {
        this.client = client;
        this.taskRunnerConfig = taskRunnerConfig;
        this.taskConfig = taskConfig;
        this.startupLoggingConfig = startupLoggingConfig;
        this.node = node;
        this.mapper = mapper;
        this.taskLogs = taskLogs;
    }

    @Override
    public Job fromTask(Task task) throws IOException {
        String myPodName = System.getenv("HOSTNAME");
        Pod pod = this.client.executeRequest(client -> (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.taskRunnerConfig.getNamespace())).withName(myPodName)).get());
        PeonCommandContext context = new PeonCommandContext(this.generateCommand(task), this.javaOpts(task), this.taskConfig.getTaskDir(task.getId()), this.taskRunnerConfig.getCpuCoreInMicro(), this.node.isEnableTlsPort());
        PodSpec podSpec = pod.getSpec();
        K8sTaskAdapter.massageSpec(podSpec, this.taskRunnerConfig.getPrimaryContainerName());
        return this.createJobFromPodSpec(podSpec, task, context);
    }

    @Override
    public Task toTask(Job from) throws IOException {
        PodSpec podSpec = from.getSpec().getTemplate().getSpec();
        K8sTaskAdapter.massageSpec(podSpec, "main");
        List envVars = ((Container)podSpec.getContainers().get(0)).getEnv();
        Optional<EnvVar> taskJson = envVars.stream().filter(x -> "TASK_JSON".equals(x.getName())).findFirst();
        String contents = taskJson.map(envVar -> ((EnvVar)taskJson.get()).getValue()).orElse(null);
        if (contents == null) {
            log.info("No TASK_JSON environment variable found in pod: %s. Trying to load task payload from deep storage.", new Object[]{from.getMetadata().getName()});
            return this.toTaskUsingDeepStorage(from);
        }
        return (Task)this.mapper.readValue(Base64Compression.decompressBase64(contents), Task.class);
    }

    private Task toTaskUsingDeepStorage(Job from) throws IOException {
        com.google.common.base.Optional taskBody = this.taskLogs.streamTaskPayload(this.getTaskId(from).getOriginalTaskId());
        if (!taskBody.isPresent()) {
            throw InternalServerError.exception((String)"Could not load task payload from deep storage for job [%s]. Check the overlord logs for any errors in uploading task payload to deep storage.", (Object[])new Object[]{from.getMetadata().getName()});
        }
        String task = IOUtils.toString((InputStream)((InputStream)taskBody.get()), (Charset)Charset.defaultCharset());
        return (Task)this.mapper.readValue(task, Task.class);
    }

    @Override
    public K8sTaskId getTaskId(Job from) {
        Map annotations = from.getSpec().getTemplate().getMetadata().getAnnotations();
        if (annotations == null) {
            throw DruidException.defensive().build("No annotations found on pod spec for job [%s]", new Object[]{from.getMetadata().getName()});
        }
        String taskId = (String)annotations.get("task.id");
        if (taskId == null) {
            throw DruidException.defensive().build("No task_id annotation found on pod spec for job [%s]", new Object[]{from.getMetadata().getName()});
        }
        return new K8sTaskId(this.taskRunnerConfig.getK8sTaskPodNamePrefix(), taskId);
    }

    @VisibleForTesting
    abstract Job createJobFromPodSpec(PodSpec var1, Task var2, PeonCommandContext var3) throws IOException;

    protected Job buildJob(K8sTaskId k8sTaskId, Map<String, String> labels, Map<String, String> annotations, PodTemplateSpec podTemplate) {
        return ((JobBuilder)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(k8sTaskId.getK8sJobName())).addToLabels(labels)).addToAnnotations(annotations)).endMetadata()).withNewSpec().withTemplate(podTemplate)).withActiveDeadlineSeconds(Long.valueOf(this.taskRunnerConfig.getTaskTimeout().toStandardDuration().getStandardSeconds()))).withBackoffLimit(Integer.valueOf(0))).withTtlSecondsAfterFinished(Integer.valueOf((int)this.taskRunnerConfig.getTaskCleanupDelay().toStandardDuration().getStandardSeconds()))).endSpec()).build();
    }

    @VisibleForTesting
    static Optional<Long> getJavaOptValueBytes(String qualifier, List<String> commands) {
        Long result = null;
        Optional<String> lastHeapValue = commands.stream().filter(x -> x.startsWith(qualifier)).reduce((x, y) -> y);
        if (lastHeapValue.isPresent()) {
            result = HumanReadableBytes.parse((String)org.apache.commons.lang3.StringUtils.removeStart((String)lastHeapValue.get(), (String)qualifier));
        }
        return Optional.ofNullable(result);
    }

    @VisibleForTesting
    static long getContainerMemory(PeonCommandContext context) {
        List<String> javaOpts = context.getJavaOpts();
        Optional<Long> optionalXmx = K8sTaskAdapter.getJavaOptValueBytes("-Xmx", javaOpts);
        long heapSize = HumanReadableBytes.parse((String)"1G");
        if (optionalXmx.isPresent()) {
            heapSize = optionalXmx.get();
        }
        Optional<Long> optionalDbb = K8sTaskAdapter.getJavaOptValueBytes("-XX:MaxDirectMemorySize=", javaOpts);
        long dbbSize = heapSize;
        if (optionalDbb.isPresent()) {
            dbbSize = optionalDbb.get();
        }
        return (long)((double)(dbbSize + heapSize) * 1.2);
    }

    protected void setupPorts(Container mainContainer) {
        mainContainer.getPorts().clear();
        ContainerPort tcpPort = new ContainerPort();
        tcpPort.setContainerPort(Integer.valueOf(8100));
        tcpPort.setName("druid-port");
        tcpPort.setProtocol("TCP");
        ContainerPort httpsPort = new ContainerPort();
        httpsPort.setContainerPort(Integer.valueOf(8091));
        httpsPort.setName("druid-tls-port");
        httpsPort.setProtocol("TCP");
        mainContainer.setPorts((List)Lists.newArrayList((Object[])new ContainerPort[]{httpsPort, tcpPort}));
    }

    @VisibleForTesting
    void addEnvironmentVariables(Container mainContainer, PeonCommandContext context, String taskContents) throws JsonProcessingException {
        if (!this.taskRunnerConfig.getPeonMonitors().isEmpty()) {
            mainContainer.getEnv().removeIf(x -> "druid_monitoring_monitors".equals(x.getName()));
            mainContainer.getEnv().add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("druid_monitoring_monitors")).withValue(this.mapper.writeValueAsString(this.taskRunnerConfig.getPeonMonitors()))).build());
        }
        ArrayList envVars = Lists.newArrayList((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("TASK_DIR")).withValue(context.getTaskDir().getAbsolutePath())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("JAVA_OPTS")).withValue(Joiner.on((String)" ").join(context.getJavaOpts()))).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("druid_host")).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withFieldRef(new ObjectFieldSelector(null, "status.podIP"))).build())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("HOSTNAME")).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withFieldRef(new ObjectFieldSelector(null, "metadata.name"))).build())).build()});
        if ((long)taskContents.length() < 130048L) {
            envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("TASK_JSON")).withValue(taskContents)).build());
        }
        mainContainer.getEnv().addAll(envVars);
    }

    protected Container setupMainContainer(PodSpec podSpec, PeonCommandContext context, long containerSize, String taskContents) throws JsonProcessingException {
        ArrayList mainCommand = Lists.newArrayList((Object[])new String[]{"sh", "-c"});
        List containers = podSpec.getContainers();
        Container mainContainer = (Container)Iterables.getFirst((Iterable)containers, null);
        if (mainContainer == null) {
            throw new IllegalArgumentException("Must have at least one container");
        }
        mainContainer.setReadinessProbe(null);
        mainContainer.setLivenessProbe(null);
        mainContainer.setStartupProbe(null);
        this.setupPorts(mainContainer);
        this.addEnvironmentVariables(mainContainer, context, taskContents);
        mainContainer.setCommand((List)mainCommand);
        mainContainer.setArgs(Collections.singletonList(Joiner.on((String)" ").join(context.getCommand())));
        mainContainer.setName("main");
        ResourceRequirements requirements = K8sTaskAdapter.getResourceRequirements(mainContainer.getResources(), containerSize, context.getCpuMicroCore());
        mainContainer.setResources(requirements);
        return mainContainer;
    }

    protected Map<String, String> addJobSpecificAnnotations(PeonCommandContext context, K8sTaskId k8sTaskId) {
        return ImmutableMap.builder().putAll(this.taskRunnerConfig.getAnnotations()).put((Object)"task.id", (Object)k8sTaskId.getOriginalTaskId()).put((Object)"tls.enabled", (Object)String.valueOf(context.isEnableTls())).build();
    }

    protected Map<String, String> addJobSpecificLabels() {
        return ImmutableMap.builder().putAll(this.taskRunnerConfig.getLabels()).put((Object)"druid.k8s.peons", (Object)"true").build();
    }

    protected PodTemplateSpec createTemplateFromSpec(K8sTaskId k8sTaskId, PodSpec podSpec, Map<String, String> annotations, Map<String, String> labels) {
        podSpec.setNodeName(null);
        podSpec.setRestartPolicy("Never");
        podSpec.setHostname(k8sTaskId.getK8sJobName());
        podSpec.setTerminationGracePeriodSeconds(this.taskRunnerConfig.getGraceTerminationPeriodSeconds());
        PodTemplateSpec podTemplate = new PodTemplateSpec();
        ObjectMeta objectMeta = new ObjectMeta();
        objectMeta.setAnnotations(annotations);
        objectMeta.setLabels(labels);
        podTemplate.setMetadata(objectMeta);
        podTemplate.setSpec(podSpec);
        return podTemplate;
    }

    @VisibleForTesting
    static void massageSpec(PodSpec spec, String primaryContainerName) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)primaryContainerName)) {
            int i;
            for (i = 0; i < spec.getContainers().size() && !primaryContainerName.equals(((Container)spec.getContainers().get(i)).getName()); ++i) {
            }
            if (i >= spec.getContainers().size()) {
                throw new IllegalArgumentException("Could not find container named: " + primaryContainerName + " in PodSpec");
            }
            Container primary = (Container)spec.getContainers().get(i);
            spec.getContainers().remove(i);
            spec.getContainers().add(0, primary);
        }
    }

    private List<String> javaOpts(Task task) {
        ArrayList<String> javaOpts = new ArrayList<String>();
        Iterables.addAll(javaOpts, this.taskRunnerConfig.getJavaOptsArray());
        Object taskJavaOpts = task.getContextValue("druid.indexer.runner.javaOpts");
        if (taskJavaOpts != null) {
            Iterables.addAll(javaOpts, (Iterable)new QuotableWhiteSpaceSplitter((String)taskJavaOpts));
        }
        javaOpts.add(StringUtils.format((String)"-Ddruid.indexer.task.baseTaskDir=%s", (Object[])new Object[]{this.taskConfig.getBaseTaskDir().getAbsolutePath()}));
        javaOpts.add(StringUtils.format((String)"-Ddruid.port=%d", (Object[])new Object[]{8100}));
        javaOpts.add(StringUtils.format((String)"-Ddruid.plaintextPort=%d", (Object[])new Object[]{8100}));
        javaOpts.add(StringUtils.format((String)"-Ddruid.tlsPort=%d", (Object[])new Object[]{this.node.isEnableTlsPort() ? 8091 : -1}));
        javaOpts.add(StringUtils.format((String)"-Ddruid.task.executor.tlsPort=%d", (Object[])new Object[]{this.node.isEnableTlsPort() ? 8091 : -1}));
        javaOpts.add(StringUtils.format((String)"-Ddruid.task.executor.enableTlsPort=%s", (Object[])new Object[]{this.node.isEnableTlsPort()}));
        return javaOpts;
    }

    private List<String> generateCommand(Task task) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/peon.sh");
        String nodeType = task.getNodeType();
        if (nodeType != null) {
            command.add("--nodeType");
            command.add(nodeType);
        }
        if (task.supportsQueries()) {
            command.add("--loadBroadcastSegments");
            command.add("true");
        }
        command.add("--loadBroadcastDatasourceMode");
        command.add(task.getBroadcastDatasourceLoadingSpec().getMode().toString());
        command.add("--taskId");
        command.add(task.getId());
        log.info("Peon Command for K8s job: %s", new Object[]{ForkingTaskRunner.getMaskedCommand((List)this.startupLoggingConfig.getMaskProperties(), command)});
        return command;
    }

    @VisibleForTesting
    static ResourceRequirements getResourceRequirements(ResourceRequirements requirements, long containerSize, int cpuMicroCore) {
        HashMap<String, Quantity> resourceMap = new HashMap<String, Quantity>();
        resourceMap.put("cpu", new Quantity(String.valueOf(cpuMicroCore > 0 ? cpuMicroCore : 1000), "m"));
        resourceMap.put("memory", new Quantity(String.valueOf(containerSize)));
        ResourceRequirementsBuilder result = new ResourceRequirementsBuilder();
        if (requirements != null) {
            if (requirements.getRequests() == null || requirements.getRequests().isEmpty()) {
                requirements.setRequests(resourceMap);
            } else {
                requirements.getRequests().putAll(resourceMap);
            }
            if (requirements.getLimits() == null || requirements.getLimits().isEmpty()) {
                requirements.setLimits(resourceMap);
            } else {
                requirements.getLimits().putAll(resourceMap);
            }
        } else {
            requirements = ((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)result.withRequests(resourceMap)).withLimits(resourceMap)).build();
        }
        return requirements;
    }

    @Override
    public boolean shouldUseDeepStorageForTaskPayload(Task task) throws IOException {
        String compressedTaskPayload = Base64Compression.compressBase64(this.mapper.writeValueAsString((Object)task));
        return (long)compressedTaskPayload.length() > 130048L;
    }
}

