/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.api.core.HttpContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.http.EngineInfo;
import org.apache.druid.sql.http.GetQueriesResponse;
import org.apache.druid.sql.http.GetQueryReportResponse;
import org.apache.druid.sql.http.QueryInfo;
import org.apache.druid.sql.http.SqlEngineRegistry;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResourceQueryResultPusher;
import org.apache.druid.sql.http.SqlResourceQueryResultPusherFactory;
import org.apache.druid.sql.http.SupportedEnginesResponse;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    public static final String PATH = "/druid/v2/sql/";
    public static final String SQL_QUERY_ID_RESPONSE_HEADER = "X-Druid-SQL-Query-Id";
    public static final String SQL_HEADER_RESPONSE_HEADER = "X-Druid-SQL-Header-Included";
    public static final String SQL_HEADER_VALUE = "yes";
    private static final Logger log = new Logger(SqlResource.class);
    public static final SqlResourceQueryMetricCounter QUERY_METRIC_COUNTER = new SqlResourceQueryMetricCounter();
    private final AuthorizerMapper authorizerMapper;
    private final SqlResourceQueryResultPusherFactory resultPusherFactory;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final SqlEngineRegistry sqlEngineRegistry;
    private final DefaultQueryConfig defaultQueryConfig;
    private final ServerConfig serverConfig;

    @Inject
    @VisibleForTesting
    public SqlResource(AuthorizerMapper authorizerMapper, SqlLifecycleManager sqlLifecycleManager, SqlEngineRegistry sqlEngineRegistry, SqlResourceQueryResultPusherFactory resultPusherFactory, DefaultQueryConfig defaultQueryConfig, ServerConfig serverConfig) {
        this.resultPusherFactory = resultPusherFactory;
        this.sqlEngineRegistry = (SqlEngineRegistry)Preconditions.checkNotNull((Object)sqlEngineRegistry, (Object)"sqlEngineRegistry");
        this.authorizerMapper = (AuthorizerMapper)Preconditions.checkNotNull((Object)authorizerMapper, (Object)"authorizerMapper");
        this.sqlLifecycleManager = (SqlLifecycleManager)Preconditions.checkNotNull((Object)sqlLifecycleManager, (Object)"sqlLifecycleManager");
        this.defaultQueryConfig = (DefaultQueryConfig)Preconditions.checkNotNull((Object)defaultQueryConfig, (Object)"defaultQueryConfig");
        this.serverConfig = serverConfig;
    }

    @GET
    @Path(value="/engines")
    @Produces(value={"application/json"})
    public Response getSupportedEngines(@Context HttpServletRequest request) {
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        Set<EngineInfo> engines = this.sqlEngineRegistry.getSupportedEngines().stream().map(EngineInfo::new).collect(Collectors.toSet());
        return Response.ok((Object)new SupportedEnginesResponse(engines)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
    @Nullable
    public Response doPost(@Context HttpServletRequest req, @Context HttpContext httpContext) {
        return this.doPost(SqlQuery.from(httpContext), req);
    }

    @GET
    @Path(value="/queries")
    @Produces(value={"application/json"})
    public Response doGetRunningQueries(@QueryParam(value="selfOnly") String selfOnly, @Context HttpServletRequest request) {
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)request);
        AuthorizationResult stateReadAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)this.authorizerMapper);
        Collection<SqlEngine> engines = this.sqlEngineRegistry.getAllEngines();
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        for (SqlEngine sqlEngine : engines) {
            queries.addAll(sqlEngine.getRunningQueries(selfOnly != null, authenticationResult, stateReadAccess).getQueries());
        }
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        return Response.ok().entity((Object)new GetQueriesResponse(queries)).build();
    }

    @GET
    @Path(value="/queries/{sqlQueryId}/reports")
    @Produces(value={"application/json"})
    public Response doGetQueryReport(@PathParam(value="sqlQueryId") String sqlQueryId, @QueryParam(value="selfOnly") String selfOnly, @Context HttpServletRequest request) {
        SqlEngine sqlEngine;
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)request);
        AuthorizationResult stateReadAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)this.authorizerMapper);
        Collection<SqlEngine> engines = this.sqlEngineRegistry.getAllEngines();
        GetQueryReportResponse retVal = null;
        Iterator<SqlEngine> iterator = engines.iterator();
        while (iterator.hasNext() && (retVal = (sqlEngine = iterator.next()).getQueryReport(sqlQueryId, selfOnly != null, authenticationResult, stateReadAccess)) == null) {
        }
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        if (retVal == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new GetQueryReportResponse(null, null)).build();
        }
        return Response.ok().entity(retVal).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPost(SqlQuery sqlQuery, HttpServletRequest req) {
        HttpStatement stmt;
        try {
            SqlQueryPlus sqlQueryPlus = SqlResource.makeSqlQueryPlus(sqlQuery, req, this.defaultQueryConfig.getContext());
            QueryContext queryContext = new QueryContext(sqlQueryPlus.context());
            String engineName = queryContext.getEngine();
            SqlEngine engine = this.sqlEngineRegistry.getEngine(engineName);
            stmt = engine.getSqlStatementFactory().httpStatement(sqlQueryPlus, req);
        }
        catch (Exception e) {
            return SqlResource.handleExceptionBeforeStatementCreated(e, sqlQuery.queryContext(), this.serverConfig.getErrorResponseTransformStrategy());
        }
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{stmt.sqlQueryId()}));
            SqlResourceQueryResultPusher pusher = this.resultPusherFactory.factorize(req, stmt, sqlQuery);
            Response response = pusher.push();
            return response;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query [%s]", new Object[]{sqlQueryId});
        List<SqlLifecycleManager.Cancelable> lifecycles = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (lifecycles.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AuthorizationResult authResult = this.authorizeCancellation(req, lifecycles);
        if (authResult.allowAccessWithNoRestriction()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, lifecycles);
            lifecycles.forEach(SqlLifecycleManager.Cancelable::cancel);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public AuthorizationResult authorizeCancellation(HttpServletRequest req, List<SqlLifecycleManager.Cancelable> cancelables) {
        Set resources = cancelables.stream().flatMap(lifecycle -> lifecycle.resources().stream()).collect(Collectors.toSet());
        return AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resources, (AuthorizerMapper)this.authorizerMapper);
    }

    public static SqlQueryPlus makeSqlQueryPlus(SqlQuery sqlQuery, HttpServletRequest req, Map<String, Object> defaultQueryConfig) {
        return SqlQueryPlus.builder().sql(sqlQuery.getQuery()).systemDefaultContext(defaultQueryConfig).queryContext(sqlQuery.getContext()).parameters(sqlQuery.getParameterList()).auth(AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req)).build();
    }

    public static Response handleExceptionBeforeStatementCreated(Exception e, QueryContext queryContext, ErrorResponseTransformStrategy strategy) {
        if (e instanceof DruidException) {
            String sqlQueryId = queryContext.getString("sqlQueryId");
            String errorId = sqlQueryId == null ? UUID.randomUUID().toString() : sqlQueryId;
            Optional transformed = strategy.maybeTransform((DruidException)((Object)e), Optional.of(errorId));
            if (transformed.isPresent()) {
                log.error((Throwable)e, StringUtils.format((String)"External Error ID: [%s]", (Object[])new Object[]{errorId}), new Object[0]);
            }
            return QueryResultPusher.handleDruidExceptionBeforeResponseStarted((DruidException)((DruidException)((Object)transformed.orElse(e))), (MediaType)MediaType.APPLICATION_JSON_TYPE, sqlQueryId != null ? ImmutableMap.builder().put((Object)"X-Druid-Query-Id", (Object)sqlQueryId).put((Object)SQL_QUERY_ID_RESPONSE_HEADER, (Object)sqlQueryId).build() : Collections.emptyMap());
        }
        return QueryResultPusher.handleDruidExceptionBeforeResponseStarted((DruidException)DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Cannot handle query", new Object[0]), (MediaType)MediaType.APPLICATION_JSON_TYPE, Collections.emptyMap());
    }

    private static class SqlResourceQueryMetricCounter
    implements QueryResource.QueryMetricCounter {
        private SqlResourceQueryMetricCounter() {
        }

        public void incrementSuccess() {
        }

        public void incrementFailed() {
        }

        public void incrementInterrupted() {
        }

        public void incrementTimedOut() {
        }
    }
}

