/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.kernel.GlobalSortShuffleSpec;
import org.apache.druid.msq.kernel.LimitHintJsonIncludeFilter;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;

public class GlobalSortMaxCountShuffleSpec
implements GlobalSortShuffleSpec {
    public static final String TYPE = "maxCount";
    private final ClusterBy clusterBy;
    private final int maxPartitions;
    private final boolean aggregate;
    private final long limitHint;

    @JsonCreator
    public GlobalSortMaxCountShuffleSpec(@JsonProperty(value="clusterBy") ClusterBy clusterBy, @JsonProperty(value="partitions") int maxPartitions, @JsonProperty(value="aggregate") boolean aggregate, @JsonProperty(value="limitHint") Long limitHint) {
        this.clusterBy = (ClusterBy)Preconditions.checkNotNull((Object)clusterBy, (Object)"clusterBy");
        this.maxPartitions = maxPartitions;
        this.aggregate = aggregate;
        long l = this.limitHint = limitHint == null ? -1L : limitHint;
        if (maxPartitions < 1) {
            throw new IAE("Partition count must be at least 1", new Object[0]);
        }
        if (!clusterBy.sortable()) {
            throw new IAE("ClusterBy key must be sortable", new Object[0]);
        }
        if (clusterBy.getBucketByCount() > 0) {
            throw new IAE("Cannot bucket with %s partitioning", new Object[]{TYPE});
        }
    }

    @Override
    public ShuffleKind kind() {
        return ShuffleKind.GLOBAL_SORT;
    }

    @Override
    @JsonProperty(value="aggregate")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean doesAggregate() {
        return this.aggregate;
    }

    @Override
    public boolean mustGatherResultKeyStatistics() {
        return this.maxPartitions > 1 || this.clusterBy.getBucketByCount() > 0;
    }

    @Override
    public Either<Long, ClusterByPartitions> generatePartitionsForGlobalSort(@Nullable ClusterByStatisticsCollector collector, int maxNumPartitions) {
        if (!this.mustGatherResultKeyStatistics()) {
            return Either.value((Object)ClusterByPartitions.oneUniversalPartition());
        }
        if (this.maxPartitions > maxNumPartitions) {
            return Either.error((Object)this.maxPartitions);
        }
        collector.logSketches();
        ClusterByPartitions generatedPartitions = collector.generatePartitionsWithMaxCount(this.maxPartitions);
        if (generatedPartitions.size() <= maxNumPartitions) {
            return Either.value((Object)generatedPartitions);
        }
        return Either.error((Object)generatedPartitions.size());
    }

    @Override
    @JsonProperty
    public ClusterBy clusterBy() {
        return this.clusterBy;
    }

    @Override
    public int partitionCount() {
        if (this.maxPartitions == 1) {
            return 1;
        }
        throw new ISE("Number of partitions not known for [%s] with maxPartitions[%d].", new Object[]{this.kind(), this.maxPartitions});
    }

    @JsonProperty(value="partitions")
    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=LimitHintJsonIncludeFilter.class)
    @JsonProperty
    public long limitHint() {
        return this.limitHint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSortMaxCountShuffleSpec that = (GlobalSortMaxCountShuffleSpec)o;
        return this.maxPartitions == that.maxPartitions && this.aggregate == that.aggregate && Objects.equals(this.clusterBy, that.clusterBy) && Objects.equals(this.limitHint, that.limitHint);
    }

    public int hashCode() {
        return Objects.hash(this.clusterBy, this.maxPartitions, this.aggregate, this.limitHint);
    }

    public String toString() {
        return "GlobalSortMaxCountShuffleSpec{clusterBy=" + String.valueOf(this.clusterBy) + ", maxPartitions=" + this.maxPartitions + ", aggregate=" + this.aggregate + ", limitHint=" + this.limitHint + "}";
    }
}

