/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.segment.incremental.InputRowFilterResult;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;

public class DropwizardRowIngestionMeters
implements RowIngestionMeters {
    public static final String ONE_MINUTE_NAME = "1m";
    public static final String FIVE_MINUTE_NAME = "5m";
    public static final String FIFTEEN_MINUTE_NAME = "15m";
    private final Meter processed;
    private final Meter processedBytes;
    private final Meter processedWithError;
    private final Meter unparseable;
    private final Meter[] thrownAwayByReason = new Meter[InputRowFilterResult.numValues()];

    public DropwizardRowIngestionMeters() {
        MetricRegistry metricRegistry = new MetricRegistry();
        this.processed = metricRegistry.meter("processed");
        this.processedBytes = metricRegistry.meter("processedBytes");
        this.processedWithError = metricRegistry.meter("processedWithError");
        this.unparseable = metricRegistry.meter("unparseable");
        for (InputRowFilterResult reason : InputRowFilterResult.values()) {
            this.thrownAwayByReason[reason.ordinal()] = metricRegistry.meter("thrownAway_" + reason.name());
        }
    }

    public long getProcessed() {
        return this.processed.getCount();
    }

    public void incrementProcessed() {
        this.processed.mark();
    }

    public long getProcessedBytes() {
        return this.processedBytes.getCount();
    }

    public void incrementProcessedBytes(long incrementByValue) {
        this.processedBytes.mark(incrementByValue);
    }

    public long getProcessedWithError() {
        return this.processedWithError.getCount();
    }

    public void incrementProcessedWithError() {
        this.processedWithError.mark();
    }

    public long getUnparseable() {
        return this.unparseable.getCount();
    }

    public void incrementUnparseable() {
        this.unparseable.mark();
    }

    public long getThrownAway() {
        long totalThrownAway = 0L;
        for (InputRowFilterResult reason : InputRowFilterResult.rejectedValues()) {
            totalThrownAway += this.thrownAwayByReason[reason.ordinal()].getCount();
        }
        return totalThrownAway;
    }

    public void incrementThrownAway(InputRowFilterResult reason) {
        this.thrownAwayByReason[reason.ordinal()].mark();
    }

    public Map<String, Long> getThrownAwayByReason() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (InputRowFilterResult reason : InputRowFilterResult.rejectedValues()) {
            long count = this.thrownAwayByReason[reason.ordinal()].getCount();
            if (count <= 0L) continue;
            result.put(reason.getReason(), count);
        }
        return result;
    }

    public RowIngestionMetersTotals getTotals() {
        return new RowIngestionMetersTotals(this.processed.getCount(), this.processedBytes.getCount(), this.processedWithError.getCount(), this.getThrownAwayByReason(), this.unparseable.getCount());
    }

    public Map<String, Object> getMovingAverages() {
        HashMap<String, Object> movingAverages = new HashMap<String, Object>();
        HashMap<String, Double> oneMinute = new HashMap<String, Double>();
        oneMinute.put("processed", this.processed.getOneMinuteRate());
        oneMinute.put("processedBytes", this.processedBytes.getOneMinuteRate());
        oneMinute.put("processedWithError", this.processedWithError.getOneMinuteRate());
        oneMinute.put("unparseable", this.unparseable.getOneMinuteRate());
        oneMinute.put("thrownAway", Arrays.stream(this.thrownAwayByReason).mapToDouble(Meter::getOneMinuteRate).sum());
        HashMap<String, Double> fiveMinute = new HashMap<String, Double>();
        fiveMinute.put("processed", this.processed.getFiveMinuteRate());
        fiveMinute.put("processedBytes", this.processedBytes.getFiveMinuteRate());
        fiveMinute.put("processedWithError", this.processedWithError.getFiveMinuteRate());
        fiveMinute.put("unparseable", this.unparseable.getFiveMinuteRate());
        fiveMinute.put("thrownAway", Arrays.stream(this.thrownAwayByReason).mapToDouble(Meter::getFiveMinuteRate).sum());
        HashMap<String, Double> fifteenMinute = new HashMap<String, Double>();
        fifteenMinute.put("processed", this.processed.getFifteenMinuteRate());
        fifteenMinute.put("processedBytes", this.processedBytes.getFifteenMinuteRate());
        fifteenMinute.put("processedWithError", this.processedWithError.getFifteenMinuteRate());
        fifteenMinute.put("unparseable", this.unparseable.getFifteenMinuteRate());
        fifteenMinute.put("thrownAway", Arrays.stream(this.thrownAwayByReason).mapToDouble(Meter::getFifteenMinuteRate).sum());
        movingAverages.put(ONE_MINUTE_NAME, oneMinute);
        movingAverages.put(FIVE_MINUTE_NAME, fiveMinute);
        movingAverages.put(FIFTEEN_MINUTE_NAME, fifteenMinute);
        return movingAverages;
    }
}

