/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServiceAccountFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ServiceAccountFluentImpl<A extends V1ServiceAccountFluent<A>>
extends BaseFluent<A>
implements V1ServiceAccountFluent<A> {
    private String apiVersion;
    private Boolean automountServiceAccountToken;
    private ArrayList<V1LocalObjectReferenceBuilder> imagePullSecrets;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1ObjectReferenceBuilder> secrets;

    public V1ServiceAccountFluentImpl() {
    }

    public V1ServiceAccountFluentImpl(V1ServiceAccount instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSecrets(instance.getSecrets());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A addToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(V1LocalObjectReference ... items) {
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items) {
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<V1LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            V1LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets != null ? V1ServiceAccountFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public List<V1LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? V1ServiceAccountFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public V1LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public V1LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public V1LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public V1LocalObjectReference buildMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(V1LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove("imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, V1LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ServiceAccountFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ServiceAccountFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ServiceAccountFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSecrets(int index, V1ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(index, builder);
            this.secrets.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, V1ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(V1ObjectReference ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<V1ObjectReference> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(V1ObjectReference ... items) {
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<V1ObjectReference> items) {
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecrets(Predicate<V1ObjectReferenceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<V1ObjectReferenceBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            V1ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ObjectReference> getSecrets() {
        return this.secrets != null ? V1ServiceAccountFluentImpl.build(this.secrets) : null;
    }

    @Override
    public List<V1ObjectReference> buildSecrets() {
        return this.secrets != null ? V1ServiceAccountFluentImpl.build(this.secrets) : null;
    }

    @Override
    public V1ObjectReference buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    @Override
    public V1ObjectReference buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public V1ObjectReference buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public V1ObjectReference buildMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<V1ObjectReference> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (V1ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(V1ObjectReference ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (V1ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> addNewSecretLike(V1ObjectReference item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> setNewSecretLike(int index, V1ObjectReference item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public V1ServiceAccountFluent.SecretsNested<A> editMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceAccountFluentImpl that = (V1ServiceAccountFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.secrets, that.secrets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.automountServiceAccountToken, this.imagePullSecrets, this.kind, this.metadata, this.secrets, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.imagePullSecrets != null) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.secrets != null) {
            sb.append("secrets:");
            sb.append(this.secrets);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    class ImagePullSecretsNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1ServiceAccountFluent.ImagePullSecretsNested<N>>
    implements V1ServiceAccountFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        V1LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNestedImpl(int index, V1LocalObjectReference item) {
            this.index = index;
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ServiceAccountFluent.MetadataNested<N>>
    implements V1ServiceAccountFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class SecretsNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1ServiceAccountFluent.SecretsNested<N>>
    implements V1ServiceAccountFluent.SecretsNested<N>,
    Nested<N> {
        V1ObjectReferenceBuilder builder;
        int index;

        SecretsNestedImpl(int index, V1ObjectReference item) {
            this.index = index;
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

