/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ModelProperties;

public class ObjectDefn {
    private final String name;
    private final String typeValue;
    private final Map<String, ModelProperties.PropertyDefn<?>> properties;

    public ObjectDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> fields) {
        this.name = name;
        this.typeValue = typeValue;
        this.properties = ObjectDefn.toPropertyMap(fields);
    }

    protected static Map<String, ModelProperties.PropertyDefn<?>> toPropertyMap(List<ModelProperties.PropertyDefn<?>> props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (props != null) {
            for (ModelProperties.PropertyDefn<?> prop : props) {
                builder.put((Object)prop.name(), prop);
            }
        }
        return builder.build();
    }

    public String name() {
        return this.name;
    }

    public String typeValue() {
        return this.typeValue;
    }

    public Map<String, ModelProperties.PropertyDefn<?>> properties() {
        return this.properties;
    }

    public ModelProperties.PropertyDefn<?> property(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> mergeProperties(Map<String, Object> source, Map<String, Object> update) {
        return CatalogUtils.mergeProperties(this.properties, source, update);
    }

    public void validate(Map<String, Object> spec, ObjectMapper jsonMapper) {
        for (ModelProperties.PropertyDefn<?> propDefn : this.properties.values()) {
            propDefn.validate(spec.get(propDefn.name()), jsonMapper);
        }
    }
}

