/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CinderPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1CinderPersistentVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.kubernetes.client.openapi.models.V1SecretReferenceBuilder;
import io.kubernetes.client.openapi.models.V1SecretReferenceFluentImpl;
import java.util.Objects;

public class V1CinderPersistentVolumeSourceFluentImpl<A extends V1CinderPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1CinderPersistentVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private V1SecretReferenceBuilder secretRef;
    private String volumeID;

    public V1CinderPersistentVolumeSourceFluentImpl() {
    }

    public V1CinderPersistentVolumeSourceFluentImpl(V1CinderPersistentVolumeSource instance) {
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withVolumeID(instance.getVolumeID());
        }
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public V1SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1CinderPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1SecretReferenceBuilder().build());
    }

    @Override
    public V1CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeID() {
        return this.volumeID;
    }

    @Override
    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CinderPersistentVolumeSourceFluentImpl that = (V1CinderPersistentVolumeSourceFluentImpl)o;
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        return Objects.equals(this.volumeID, that.volumeID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeID, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.volumeID != null) {
            sb.append("volumeID:");
            sb.append(this.volumeID);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends V1SecretReferenceFluentImpl<V1CinderPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements V1CinderPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        V1SecretReferenceBuilder builder;

        SecretRefNestedImpl(V1SecretReference item) {
            this.builder = new V1SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CinderPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

