/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IPBlockFluent<A extends IPBlockFluent<A>>
extends BaseFluent<A> {
    private String cidr;
    private List<String> except = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public IPBlockFluent() {
    }

    public IPBlockFluent(IPBlock instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IPBlock instance) {
        IPBlock iPBlock = instance = instance != null ? instance : new IPBlock();
        if (instance != null) {
            this.withCidr(instance.getCidr());
            this.withExcept(instance.getExcept());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCidr() {
        return this.cidr;
    }

    public A withCidr(String cidr) {
        this.cidr = cidr;
        return (A)((Object)this);
    }

    public boolean hasCidr() {
        return this.cidr != null;
    }

    public A addToExcept(int index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(index, item);
        return (A)((Object)this);
    }

    public A setToExcept(int index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.set(index, item);
        return (A)((Object)this);
    }

    public A addToExcept(String ... items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExcept(Collection<String> items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExcept(String ... items) {
        if (this.except == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.except.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExcept(Collection<String> items) {
        if (this.except == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.except.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExcept() {
        return this.except;
    }

    public String getExcept(int index) {
        return this.except.get(index);
    }

    public String getFirstExcept() {
        return this.except.get(0);
    }

    public String getLastExcept() {
        return this.except.get(this.except.size() - 1);
    }

    public String getMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExcept(List<String> except) {
        if (except != null) {
            this.except = new ArrayList<String>();
            for (String item : except) {
                this.addToExcept(item);
            }
        } else {
            this.except = null;
        }
        return (A)((Object)this);
    }

    public A withExcept(String ... except) {
        if (this.except != null) {
            this.except.clear();
            this._visitables.remove((Object)"except");
        }
        if (except != null) {
            for (String item : except) {
                this.addToExcept(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExcept() {
        return this.except != null && !this.except.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPBlockFluent that = (IPBlockFluent)((Object)o);
        if (!Objects.equals(this.cidr, that.cidr)) {
            return false;
        }
        if (!Objects.equals(this.except, that.except)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cidr, this.except, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidr != null) {
            sb.append("cidr:");
            sb.append(this.cidr + ",");
        }
        if (this.except != null && !this.except.isEmpty()) {
            sb.append("except:");
            sb.append(String.valueOf(this.except) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

