/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.tuple.sql.ArrayOfDoublesSketchSqlOperators;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayOfDoublesSketchSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new ArrayOfDoublesSqlAggFunction();
    private static final String NAME = "DS_TUPLE_DOUBLES";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        int metricExpressionEndIndex;
        int nominalEntries;
        int lastArgIndex;
        List argList = aggregateCall.getArgList();
        RexNode potentialNominalEntriesArg = inputAccessor.getField(((Integer)argList.get(lastArgIndex = argList.size() - 1)).intValue());
        if (potentialNominalEntriesArg.isA(SqlKind.LITERAL) && RexLiteral.value((RexNode)potentialNominalEntriesArg) instanceof Number) {
            nominalEntries = ((Number)((Object)RexLiteral.value((RexNode)potentialNominalEntriesArg))).intValue();
            metricExpressionEndIndex = lastArgIndex - 1;
        } else {
            nominalEntries = 4096;
            metricExpressionEndIndex = lastArgIndex;
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i <= metricExpressionEndIndex; ++i) {
            String fieldName;
            RexNode columnRexNode = inputAccessor.getField(((Integer)argList.get(i)).intValue());
            DruidExpression columnArg = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)columnRexNode);
            if (columnArg == null) {
                return null;
            }
            if (columnArg.isDirectColumnAccess() && inputAccessor.getInputRowSignature().getColumnType(columnArg.getDirectColumn()).map(type -> type.is((TypeDescriptor)ValueType.COMPLEX)).orElse(false).booleanValue()) {
                fieldName = columnArg.getDirectColumn();
            } else {
                DimensionSpec dimensionSpec;
                RelDataType dataType = columnRexNode.getType();
                ColumnType inputType = Calcites.getColumnTypeForRelDataType((RelDataType)dataType);
                if (inputType == null) {
                    throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{dataType.getSqlTypeName(), name});
                }
                if (columnArg.isDirectColumnAccess()) {
                    dimensionSpec = columnArg.getSimpleExtraction().toDimensionSpec(null, inputType);
                } else {
                    String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(columnArg, dataType);
                    dimensionSpec = new DefaultDimensionSpec(virtualColumnName, null, inputType);
                }
                fieldName = dimensionSpec.getDimension();
            }
            fieldNames.add(fieldName);
        }
        List<String> metricColumns = fieldNames.size() > 1 ? fieldNames.subList(1, fieldNames.size()) : null;
        ArrayOfDoublesSketchAggregatorFactory aggregatorFactory = new ArrayOfDoublesSketchAggregatorFactory(name, (String)fieldNames.get(0), nominalEntries, metricColumns, null);
        return Aggregation.create(Collections.singletonList(aggregatorFactory), null);
    }

    private static class ArrayOfDoublesSqlAggFunction
    extends SqlAggFunction {
        ArrayOfDoublesSqlAggFunction() {
            super(ArrayOfDoublesSketchSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, ArrayOfDoublesSketchSqlOperators.RETURN_TYPE_INFERENCE, InferTypes.VARCHAR_1024, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }
}

