/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.persistence;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.persistence.ExchangeData;
import org.apache.cxf.management.persistence.ExchangeDataDAO;
import org.apache.cxf.management.persistence.ExchangeDataProperty;

public class FilesystemExchangeDataDAO
implements ExchangeDataDAO {
    private static final Logger LOG = LogUtils.getL7dLogger(FilesystemExchangeDataDAO.class);
    private String directory;
    private String extension = "txt";

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void save(ExchangeData exchange) throws Exception {
        Path file = this.directory == null ? Files.createTempFile("cxf-management-", "." + this.extension, new FileAttribute[0]) : Files.createTempFile(Paths.get(this.directory, new String[0]), "cxf-management-", "." + this.extension, new FileAttribute[0]);
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            bw.append("Service : ").append(exchange.getServiceName()).append('\n');
            bw.append("Operation : ").append(exchange.getOperation()).append('\n');
            bw.append("Status : ").append(exchange.getStatus()).append('\n');
            bw.append("URI : ").append(exchange.getUri()).append('\n');
            bw.append("User agent : ").append(exchange.getUserAgent()).append('\n');
            bw.append("Encoding : ").append(exchange.getEncoding()).append('\n');
            bw.append("Date in : ").append(String.valueOf(exchange.getInDate())).append('\n');
            bw.append("Date out : ").append(String.valueOf(exchange.getOutDate())).append('\n');
            bw.append("Request size : ").append(String.valueOf(exchange.getRequestSize())).append('\n');
            bw.append("Response size : ").append(String.valueOf(exchange.getResponseSize())).append('\n');
            bw.append("\n\n\nRequest : \n\n\n").append(exchange.getRequest()).append("\n\n\n\n");
            bw.append("\n\n\nResponse : \n\n\n").append(exchange.getResponse()).append("\n\n\n\n");
            if ("ERROR".equals(exchange.getStatus())) {
                bw.append("\n\n\nExcepttion : ").append(exchange.getExceptionType());
                bw.append("\nStackTrace : ").append(exchange.getStackTrace());
                bw.append("\n\n\n\n");
            }
            bw.append("\n\nProperties : \n");
            if (exchange.getProperties() != null) {
                for (ExchangeDataProperty edp : exchange.getProperties()) {
                    bw.append(edp.getName()).append(" : ").append(edp.getValue()).append('\n');
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exchange data saved in " + String.valueOf(file));
        }
    }
}

