/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.persistence.config.PersistedConfiguration;
import org.apache.activemq.artemis.utils.BufferHelper;

public class PersistedUser
extends PersistedConfiguration {
    private String username;
    private String password;

    public PersistedUser() {
    }

    public PersistedUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public byte getRecordType() {
        return 47;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getEncodeSize() {
        int size = 0;
        size += BufferHelper.sizeOfString((String)this.username);
        return size += BufferHelper.sizeOfString((String)this.password);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.username);
        buffer.writeString(this.password);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.username = buffer.readString();
        this.password = buffer.readString();
    }

    public String toString() {
        return "PersistedUser [storeId=" + this.storeId + ", username=" + this.username + ", password=****]";
    }
}

