/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.client;

import java.io.IOException;
import javax.annotation.Nullable;
import scala.Tuple2;

public class MasterNotLeaderException
extends IOException {
    private static final long serialVersionUID = -2552475565785098271L;
    private final String leaderPeer;
    private final String internalLeaderPeer;
    public static final String LEADER_NOT_PRESENTED = "leader is not present";

    public MasterNotLeaderException(String currentPeer, String suggestedLeaderPeer, @Nullable Throwable cause) {
        this(currentPeer, (Tuple2<String, String>)Tuple2.apply((Object)suggestedLeaderPeer, (Object)suggestedLeaderPeer), (Tuple2<String, String>)Tuple2.apply((Object)suggestedLeaderPeer, (Object)suggestedLeaderPeer), false, cause);
    }

    public MasterNotLeaderException(String currentPeer, Tuple2<String, String> suggestedLeaderPeer, Tuple2<String, String> suggestedInternalLeaderPeer, boolean bindPreferIp, @Nullable Throwable cause) {
        super(String.format("Master:%s is not the leader.%s%s", currentPeer, currentPeer.equals(suggestedLeaderPeer._1) ? "" : String.format(" Suggested leader is Master:%s (%s).", suggestedLeaderPeer, suggestedInternalLeaderPeer), cause == null ? "" : String.format(" Exception:%s.", cause.getMessage())), cause);
        this.leaderPeer = bindPreferIp ? (String)suggestedLeaderPeer._1 : (String)suggestedLeaderPeer._2;
        this.internalLeaderPeer = bindPreferIp ? (String)suggestedInternalLeaderPeer._1 : (String)suggestedInternalLeaderPeer._2;
    }

    public String getSuggestedLeaderAddress() {
        return this.leaderPeer;
    }

    public String getSuggestedInternalLeaderAddress() {
        return this.internalLeaderPeer;
    }
}

