/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Iterator;
import org.apache.celeborn.shaded.org.roaringbitmap.BitmapContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.CharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.Container;
import org.apache.celeborn.shaded.org.roaringbitmap.ContainerBatchIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.IntConsumer;
import org.apache.celeborn.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.Util;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.BitmapBatchIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableBitmapContainerCharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableRunContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.ReverseMappeableBitmapContainerCharIterator;

public final class MappeableBitmapContainer
extends MappeableContainer
implements Cloneable {
    protected static final int MAX_CAPACITY = 65536;
    private static final long serialVersionUID = 2L;
    private static final int BLOCKSIZE = 128;
    private static final boolean USE_BRANCHLESS = true;
    LongBuffer bitmap;
    int cardinality;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public MappeableBitmapContainer() {
        this.cardinality = 0;
        this.bitmap = LongBuffer.allocate(1024);
    }

    public MappeableBitmapContainer(BitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongBuffer();
    }

    public MappeableBitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = LongBuffer.allocate(1024);
        Util.setBitmapRange(this.bitmap.array(), firstOfRun, lastOfRun);
    }

    MappeableBitmapContainer(int newCardinality, LongBuffer newBitmap) {
        this.cardinality = newCardinality;
        LongBuffer tmp = newBitmap.duplicate();
        this.bitmap = LongBuffer.allocate(tmp.limit());
        tmp.rewind();
        this.bitmap.put(tmp);
    }

    public MappeableBitmapContainer(LongBuffer array, int initCardinality) {
        if (array.limit() != 1024) {
            throw new RuntimeException("Mismatch between buffer and storage requirements: " + array.limit() + " vs. " + 1024);
        }
        this.cardinality = initCardinality;
        this.bitmap = array;
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        MappeableBitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        BufferUtil.setBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, end - begin);
        return answer;
    }

    @Override
    public MappeableContainer add(char i) {
        long previous = this.bitmap.get(i / 64);
        long newv = previous | 1L << i;
        this.bitmap.put(i / 64, newv);
        this.cardinality += (int)((previous ^ newv) >>> i);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(value2.content.limit());
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        char[] sarray = answer.content.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            char[] c = value2.content.array();
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                char v;
                sarray[answer.cardinality] = v = c[k];
                answer.cardinality += (int)this.bitValue(v);
            }
        } else {
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                char v;
                sarray[answer.cardinality] = v = value2.content.get(k);
                answer.cardinality += (int)this.bitValue(v);
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(tb[k] & v2b[k]);
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] tb = this.bitmap.array();
                long[] v2b = value2.bitmap.array();
                int len3 = this.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = tb[k3] & v2b[k3];
                }
            } else {
                len = this.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) & value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            Util.fillArrayAND(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer and(MappeableRunContainer value2) {
        return value2.and(this);
    }

    @Override
    public MappeableContainer andNot(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content) && BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            char[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                char v = v2[k];
                int i = v >>> 6;
                long w = bitArray[i];
                bitArray[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                char v2 = value2.content.get(k);
                int i = v2 >>> 6;
                long w = bitArray[i];
                bitArray[i] = aft = bitArray[i] & (1L << v2 ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v2));
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(b[k] & (v2[k] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & (value2.bitmap.get(k2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                int len3 = answer.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = b[k3] & (v2[k3] ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                len = answer.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) & (value2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            Util.fillArrayANDNOT(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        long[] b = answer.bitmap.array();
        for (int rlepos = 0; rlepos < value2.nbrruns; ++rlepos) {
            char start2 = value2.getValue(rlepos);
            int end = value2.getValue(rlepos) + value2.getLength(rlepos) + 1;
            int prevOnesInRange = Util.cardinalityInBitmapRange(b, start2, end);
            Util.resetBitmapRange(b, start2, end);
            answer.updateCardinality(prevOnesInRange, 0);
        }
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                this.bitmap.put(k, 0L);
            }
        }
    }

    @Override
    public MappeableBitmapContainer clone() {
        return new MappeableBitmapContainer(this.cardinality, this.bitmap);
    }

    private void computeCardinality() {
        this.cardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                this.cardinality += Long.bitCount(b[k]);
            }
        } else {
            int m = this.bitmap.limit();
            for (int k = 0; k < m; ++k) {
                this.cardinality += Long.bitCount(this.bitmap.get(k));
            }
        }
    }

    int cardinalityInRange(int start2, int end) {
        assert (this.cardinality != -1);
        if (end - start2 > 32768) {
            int before = BufferUtil.cardinalityInBitmapRange(this.bitmap, 0, start2);
            int after = BufferUtil.cardinalityInBitmapRange(this.bitmap, end, 65536);
            return this.cardinality - before - after;
        }
        return BufferUtil.cardinalityInBitmapRange(this.bitmap, start2, end);
    }

    void updateCardinality(int prevOnes, int newOnes) {
        int oldCardinality = this.cardinality;
        this.cardinality = oldCardinality - prevOnes + newOnes;
    }

    @Override
    public boolean contains(char i) {
        return (this.bitmap.get(i >>> 6) & 1L << i) != 0L;
    }

    long bitValue(char i) {
        return this.bitmap.get(i >>> 6) >>> i & 1L;
    }

    public static boolean contains(ByteBuffer buf, int position, char i) {
        return (buf.getLong((i >>> 6 << 3) + position) & 1L << i) != 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableBitmapContainer) {
            MappeableBitmapContainer srb = (MappeableBitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(srb.bitmap)) {
                long[] b = this.bitmap.array();
                long[] s = srb.bitmap.array();
                int len = this.bitmap.limit();
                for (int k = 0; k < len; ++k) {
                    if (b[k] == s[k]) continue;
                    return false;
                }
            } else {
                int len = this.bitmap.limit();
                for (int k = 0; k < len; ++k) {
                    if (this.bitmap.get(k) == srb.bitmap.get(k)) continue;
                    return false;
                }
            }
            return true;
        }
        if (o instanceof MappeableRunContainer) {
            return o.equals(this);
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        int base = mask;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                for (long bitset = b[k]; bitset != 0L; bitset &= bitset - 1L) {
                    x[pos++] = base + Long.numberOfTrailingZeros(bitset);
                }
                base += 64;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset &= bitset - 1L) {
                    x[pos++] = base + Long.numberOfTrailingZeros(bitset);
                }
                base += 64;
            }
        }
    }

    @Override
    public MappeableContainer flip(char i) {
        long bef = this.bitmap.get(i >>> 6);
        long mask = 1L << i;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap.put(i >>> 6, bef & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        long aft = bef ^ mask;
        this.cardinality += 1 - 2 * (int)((bef & mask) >>> i);
        this.bitmap.put(i >>> 6, aft);
        return this;
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public CharIterator getReverseCharIterator() {
        if (this.isArrayBacked()) {
            return BitmapContainer.getReverseShortIterator(this.bitmap.array());
        }
        return new ReverseMappeableBitmapContainerCharIterator(this);
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        if (this.isArrayBacked()) {
            return BitmapContainer.getShortIterator(this.bitmap.array());
        }
        return new MappeableBitmapContainerCharIterator(this);
    }

    @Override
    public ContainerBatchIterator getBatchIterator() {
        return new BitmapBatchIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.limit() * 8;
    }

    public int hashCode() {
        long hash = 0L;
        int len = this.bitmap.limit();
        for (int k = 0; k < len; ++k) {
            hash += 31L * hash + this.bitmap.get(k);
        }
        return (int)hash;
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        BufferUtil.setBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, end - begin);
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableArrayContainer b2) {
        if (-1 == this.cardinality) {
            BufferUtil.intersectArrayIntoBitmap(this.bitmap, b2.content, b2.cardinality);
            return this;
        }
        return b2.and(this);
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer b2) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k;
            int newCardinality = 0;
            long[] tb = this.bitmap.array();
            long[] tb2 = b2.bitmap.array();
            int len = this.bitmap.limit();
            if (-1 == this.cardinality) {
                for (int k2 = 0; k2 < len; ++k2) {
                    int n = k2;
                    tb[n] = tb[n] & tb2[k2];
                }
                return this;
            }
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(tb[k] & tb2[k]);
            }
            if (newCardinality > 4096) {
                for (k = 0; k < len; ++k) {
                    int n = k;
                    tb[n] = tb[n] & tb2[k];
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
            ac.cardinality = newCardinality;
            return ac;
        }
        if (-1 != this.cardinality) {
            int k;
            int newCardinality = 0;
            int len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(this.bitmap.get(k) & b2.bitmap.get(k));
            }
            if (newCardinality > 4096) {
                for (k = 0; k < len; ++k) {
                    this.bitmap.put(k, this.bitmap.get(k) & b2.bitmap.get(k));
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
            ac.cardinality = newCardinality;
            return ac;
        }
        int len = this.bitmap.limit();
        for (int k = 0; k < len; ++k) {
            this.bitmap.put(k, this.bitmap.get(k) & b2.bitmap.get(k));
        }
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer x) {
        int card = x.getCardinality();
        if (-1 != this.cardinality && card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = x.getValue(rlepos);
                int runEnd = runStart + x.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content.put(answer.cardinality, (char)runValue);
                    answer.cardinality += (int)this.bitValue((char)runValue);
                }
            }
            return answer;
        }
        int start2 = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char end = x.getValue(rlepos);
            if (-1 == this.cardinality) {
                BufferUtil.resetBitmapRange(this.bitmap, start2, end);
            } else {
                int prevOnes = this.cardinalityInRange(start2, end);
                BufferUtil.resetBitmapRange(this.bitmap, start2, end);
                this.updateCardinality(prevOnes, 0);
            }
            start2 = end + x.getLength(rlepos) + 1;
        }
        if (-1 == this.cardinality) {
            BufferUtil.resetBitmapRange(this.bitmap, start2, 65536);
        } else {
            int ones = this.cardinalityInRange(start2, 65536);
            BufferUtil.resetBitmapRange(this.bitmap, start2, 65536);
            this.updateCardinality(ones, 0);
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
        }
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content.get(k));
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableBitmapContainer b2) {
        int k;
        int newCardinality = 0;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            int len = this.bitmap.limit();
            for (k2 = 0; k2 < len; ++k2) {
                newCardinality += Long.bitCount(b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < len; ++k2) {
                    this.bitmap.put(k2, b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayANDNOT(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        int len = this.bitmap.limit();
        for (k = 0; k < len; ++k) {
            newCardinality += Long.bitCount(b[k] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < len; ++k) {
                int n = k;
                b[n] = b[n] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                char start2 = x.getValue(rlepos);
                int end = start2 + x.getLength(rlepos) + 1;
                int prevOnesInRange = Util.cardinalityInBitmapRange(b, start2, end);
                Util.resetBitmapRange(b, start2, end);
                this.updateCardinality(prevOnesInRange, 0);
            }
            if (this.getCardinality() > 4096) {
                return this;
            }
            return this.toArrayContainer();
        }
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start3 = x.getValue(rlepos);
            int end = start3 + x.getLength(rlepos) + 1;
            int prevOnesInRange = this.cardinalityInRange(start3, end);
            BufferUtil.resetBitmapRange(this.bitmap, start3, end);
            this.updateCardinality(prevOnesInRange, 0);
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    MappeableContainer ilazyor(MappeableArrayContainer value2) {
        this.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            char v2 = value2.content.get(k);
            int n = i = v2 >>> 6;
            b[n] = b[n] | 1L << v2;
        }
        return this;
    }

    MappeableContainer ilazyor(MappeableBitmapContainer x) {
        if (BufferUtil.isBackedBySimpleArray(x.bitmap)) {
            long[] b = this.bitmap.array();
            long[] b2 = x.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int n = k;
                b[n] = b[n] | b2[k];
            }
        } else {
            int m = this.bitmap.limit();
            for (int k = 0; k < m; ++k) {
                this.bitmap.put(k, this.bitmap.get(k) | x.bitmap.get(k));
            }
        }
        this.cardinality = -1;
        return this;
    }

    MappeableContainer ilazyor(MappeableRunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            BufferUtil.setBitmapRange(this.bitmap, start2, end);
        }
        this.cardinality = -1;
        return this;
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        int prevOnes = this.cardinalityInRange(firstOfRange, lastOfRange);
        BufferUtil.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
        this.updateCardinality(prevOnes, lastOfRange - firstOfRange - prevOnes);
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public boolean intersects(MappeableArrayContainer value2) {
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            char[] c = value2.content.array();
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                if (!this.contains(c[k])) continue;
                return true;
            }
        } else {
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                char v = value2.content.get(k);
                if (!this.contains(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableBitmapContainer value2) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                if ((tb[k] & v2b[k]) == 0L) continue;
                return true;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                if ((this.bitmap.get(k) & value2.bitmap.get(k)) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        return x.intersects(this);
    }

    @Override
    public MappeableBitmapContainer ior(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            char[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                int i = v2[k] >>> 6;
                long bef = b[i];
                b[i] = aft = bef | 1L << v2[k];
                this.cardinality += (int)(bef - aft >>> 63);
            }
            return this;
        }
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            char v2 = value2.content.get(k);
            int i = v2 >>> 6;
            long bef = b[i];
            b[i] = aft = bef | 1L << v2;
            this.cardinality += (int)(bef - aft >>> 63);
        }
        return this;
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer b2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        this.cardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            long[] b2Arr = b2.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long w;
                b[k] = w = b[k] | b2Arr[k];
                this.cardinality += Long.bitCount(w);
            }
            if (this.isFull()) {
                return MappeableRunContainer.full();
            }
            return this;
        }
        int len = this.bitmap.limit();
        for (int k = 0; k < len; ++k) {
            long w;
            b[k] = w = b[k] | b2.bitmap.get(k);
            this.cardinality += Long.bitCount(w);
        }
        if (this.isFull()) {
            return MappeableRunContainer.full();
        }
        return this;
    }

    @Override
    public boolean isFull() {
        return this.cardinality == 65536;
    }

    @Override
    public void orInto(long[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            int n = i;
            bits[n] = bits[n] | this.bitmap.get(i);
        }
    }

    @Override
    public void andInto(long[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            int n = i;
            bits[n] = bits[n] & this.bitmap.get(i);
        }
    }

    @Override
    public void removeFrom(long[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            int n = i;
            bits[n] = bits[n] & (this.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                char start2 = x.getValue(rlepos);
                int end = start2 + x.getLength(rlepos) + 1;
                int prevOnesInRange = Util.cardinalityInBitmapRange(b, start2, end);
                Util.setBitmapRange(b, start2, end);
                this.updateCardinality(prevOnesInRange, end - start2);
            }
        } else {
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                char start3 = x.getValue(rlepos);
                int end = start3 + x.getLength(rlepos) + 1;
                int prevOnesInRange = this.cardinalityInRange(start3, end);
                BufferUtil.setBitmapRange(this.bitmap, start3, end);
                this.updateCardinality(prevOnesInRange, end - start3);
            }
        }
        if (this.isFull()) {
            return MappeableRunContainer.full();
        }
        return this;
    }

    @Override
    public MappeableContainer iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        BufferUtil.resetBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, 0);
        if (this.getCardinality() < 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.bitmap);
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(){
            final CharIterator si;
            {
                this.si = MappeableBitmapContainer.this.getCharIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Character next() {
                return Character.valueOf(this.si.next());
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            char[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                char vc = v2[k];
                long mask = 1L << v2[k];
                int index = vc >>> 6;
                long ba = b[index];
                this.cardinality += 1 - 2 * (int)((ba & mask) >>> vc);
                b[index] = ba ^ mask;
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                char v2 = value2.content.get(k);
                long mask = 1L << v2;
                int index = v2 >>> 6;
                long ba = b[index];
                this.cardinality += 1 - 2 * (int)((ba & mask) >>> v2);
                b[index] = ba ^ mask;
            }
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer b2) {
        int k;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            int newCardinality = 0;
            int len = this.bitmap.limit();
            for (k2 = 0; k2 < len; ++k2) {
                newCardinality += Long.bitCount(b[k2] ^ b2Arr[k2]);
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < len; ++k2) {
                    int n = k2;
                    b[n] = b[n] ^ b2Arr[k2];
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayXOR(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        int newCardinality = 0;
        int len = this.bitmap.limit();
        for (k = 0; k < len; ++k) {
            newCardinality += Long.bitCount(b[k] ^ b2.bitmap.get(k));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < len; ++k) {
                int n = k;
                b[n] = b[n] ^ b2.bitmap.get(k);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer ixor(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                char start2 = x.getValue(rlepos);
                int end = start2 + x.getLength(rlepos) + 1;
                int prevOnes = Util.cardinalityInBitmapRange(b, start2, end);
                Util.flipBitmapRange(b, start2, end);
                this.updateCardinality(prevOnes, end - start2 - prevOnes);
            }
        } else {
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                char start3 = x.getValue(rlepos);
                int end = start3 + x.getLength(rlepos) + 1;
                int prevOnes = this.cardinalityInRange(start3, end);
                BufferUtil.flipBitmapRange(this.bitmap, start3, end);
                this.updateCardinality(prevOnes, end - start3 - prevOnes);
            }
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected MappeableContainer lazyor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        answer.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = answer.bitmap.array();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            char v2 = value2.content.get(k);
            int n = i = v2 >>> 6;
            b[n] = b[n] | 1L << v2;
        }
        return answer;
    }

    protected MappeableContainer lazyor(MappeableBitmapContainer x) {
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        answer.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = answer.bitmap.array();
        for (int k = 0; k < b.length; ++k) {
            b[k] = this.bitmap.get(k) | x.bitmap.get(k);
        }
        return answer;
    }

    protected MappeableContainer lazyor(MappeableRunContainer x) {
        MappeableBitmapContainer bc = this.clone();
        bc.cardinality = -1;
        long[] b = bc.bitmap.array();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            Util.setBitmapRange(b, start2, end);
        }
        return bc;
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            MappeableArrayContainer ac = new MappeableArrayContainer(maxcardinality);
            int pos = 0;
            if (!BufferUtil.isBackedBySimpleArray(ac.content)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            char[] cont = ac.content.array();
            int len = this.bitmap.limit();
            for (int k = 0; ac.cardinality < maxcardinality && k < len; ++k) {
                for (long bitset = this.bitmap.get(k); ac.cardinality < maxcardinality && bitset != 0L; bitset &= bitset - 1L) {
                    cont[pos++] = (char)(k * 64 + Long.numberOfTrailingZeros(bitset));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        LongBuffer newBitmap = LongBuffer.allocate(1024);
        MappeableBitmapContainer bc = new MappeableBitmapContainer(newBitmap, maxcardinality);
        char s = this.select(maxcardinality);
        int usedwords = s + 63 >>> 6;
        if (this.isArrayBacked()) {
            long[] source = this.bitmap.array();
            long[] dest = newBitmap.array();
            System.arraycopy(source, 0, dest, 0, usedwords);
        } else {
            for (int k = 0; k < usedwords; ++k) {
                bc.bitmap.put(k, this.bitmap.get(k));
            }
        }
        int lastword = s % 64;
        if (lastword != 0) {
            bc.bitmap.put(s >>> 6, bc.bitmap.get(s >>> 6) & -1L >>> 64 - lastword);
        }
        return bc;
    }

    void loadData(MappeableArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(arrayContainer.content)) {
            long[] b = this.bitmap.array();
            char[] ac = arrayContainer.content.array();
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                char x = ac[k];
                bitArray[x >>> 6] = b[x >>> 6] | 1L << x;
            }
        } else {
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                char x = arrayContainer.content.get(k);
                bitArray[x >>> 6] = this.bitmap.get(x >>> 6) | 1L << x;
            }
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < 1024) {
            long X = this.bitmap.get(x);
            if (X != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(X);
            }
            ++x;
        }
        return -1;
    }

    private int nextClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        int length = this.bitmap.limit();
        ++x;
        while (x < length) {
            long map = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
            if (map != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(map);
            }
            ++x;
        }
        return 65536;
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        MappeableBitmapContainer answer = this.clone();
        return answer.inot(firstOfRange, lastOfRange);
    }

    @Override
    int numberOfRuns() {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] src = this.bitmap.array();
            int numRuns = 0;
            long nextWord = src[0];
            for (int i = 0; i < src.length - 1; ++i) {
                long word = nextWord;
                nextWord = src[i + 1];
                numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
            }
            long word = nextWord;
            numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            if ((word & Long.MIN_VALUE) != 0L) {
                ++numRuns;
            }
            return numRuns;
        }
        int numRuns = 0;
        long nextWord = this.bitmap.get(0);
        int len = this.bitmap.limit();
        for (int i = 0; i < len - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap.get(i + 1);
            numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    private int numberOfRunsAdjustment() {
        int ans = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            long nextWord = b[0];
            for (int i = 0; i < b.length - 1; ++i) {
                long word = nextWord;
                nextWord = b[i + 1];
                ans += (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
            }
            long word = nextWord;
            if ((word & Long.MIN_VALUE) != 0L) {
                ++ans;
            }
        } else {
            long nextWord = this.bitmap.get(0);
            int len = this.bitmap.limit();
            for (int i = 0; i < len - 1; ++i) {
                long word = nextWord;
                nextWord = this.bitmap.get(i + 1);
                ans += (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
            }
            long word = nextWord;
            if ((word & Long.MIN_VALUE) != 0L) {
                ++ans;
            }
        }
        return ans;
    }

    private int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            int blockOffset = 0;
            while (blockOffset + 128 <= b.length) {
                for (int i = blockOffset; i < blockOffset + 128; ++i) {
                    long word = b[i];
                    numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
                }
                if (numRuns > mustNotExceed) {
                    return numRuns;
                }
                blockOffset += 128;
            }
        } else {
            int len = this.bitmap.limit();
            for (int blockOffset = 0; blockOffset < len; blockOffset += 128) {
                for (int i = blockOffset; i < blockOffset + 128; ++i) {
                    long word = this.bitmap.get(i);
                    numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
                }
                if (numRuns <= mustNotExceed) continue;
                return numRuns;
            }
        }
        return numRuns;
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(answer.bitmap) && BufferUtil.isBackedBySimpleArray(value2.content)) {
            long[] ab = answer.bitmap.array();
            char[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                char v = v2[k];
                int i = v >>> 6;
                long w = ab[i];
                bitArray[i] = aft = w | 1L << v;
                answer.cardinality += (int)(w - aft >>> 63);
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                char v2 = value2.content.get(k);
                int i = v2 >>> 6;
                long w = answer.bitmap.get(i);
                bitArray[i] = aft = w | 1L << v2;
                answer.cardinality += (int)(w - aft >>> 63);
            }
        }
        if (answer.isFull()) {
            return MappeableRunContainer.full();
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer value2) {
        MappeableBitmapContainer value1 = this.clone();
        return value1.ior(value2);
    }

    @Override
    public MappeableContainer or(MappeableRunContainer value2) {
        return value2.or(this);
    }

    int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            long X = this.bitmap.get(x);
            if (X != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(X);
            }
            --x;
        }
        return -1;
    }

    private int prevClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            long map = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
            if (map != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(map);
            }
            --x;
        }
        return -1;
    }

    @Override
    public int rank(char lowbits) {
        int leftover = lowbits + '\u0001' & 0x3F;
        int answer = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < lowbits + '\u0001' >>> 6; ++k) {
                answer += Long.bitCount(b[k]);
            }
            if (leftover != 0) {
                answer += Long.bitCount(b[lowbits + '\u0001' >>> 6] << 64 - leftover);
            }
        } else {
            for (int k = 0; k < lowbits + '\u0001' >>> 6; ++k) {
                answer += Long.bitCount(this.bitmap.get(k));
            }
            if (leftover != 0) {
                answer += Long.bitCount(this.bitmap.get(lowbits + '\u0001' >>> 6) << 64 - leftover);
            }
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.cardinality = 0;
        int len = this.bitmap.limit();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < len; ++k) {
                long w;
                b[k] = w = Long.reverseBytes(in.readLong());
                this.cardinality += Long.bitCount(w);
            }
        } else {
            for (int k = 0; k < len; ++k) {
                long w = Long.reverseBytes(in.readLong());
                this.bitmap.put(k, w);
                this.cardinality += Long.bitCount(w);
            }
        }
    }

    @Override
    public MappeableContainer remove(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        MappeableBitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        BufferUtil.resetBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, 0);
        if (answer.getCardinality() < 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer remove(char i) {
        long X = this.bitmap.get(i >>> 6);
        long mask = 1L << i;
        if (this.cardinality == 4097 && (X & mask) != 0L) {
            --this.cardinality;
            this.bitmap.put(i >>> 6, X & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        long aft = X & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - X >>> 63));
        this.bitmap.put(i >>> 6, aft);
        return this;
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
            if (this.isFull()) {
                return MappeableRunContainer.full();
            }
        }
        return this;
    }

    @Override
    public MappeableContainer runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = MappeableRunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = MappeableRunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new MappeableRunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public char select(int j) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            if (this.cardinality >>> 1 < j && j < this.cardinality) {
                int leftover = this.cardinality - j;
                for (int k = b.length - 1; k >= 0; --k) {
                    long w = b[k];
                    if (w == 0L) continue;
                    int bits = Long.bitCount(w);
                    if (bits >= leftover) {
                        return (char)(k * 64 + Util.select(w, bits - leftover));
                    }
                    leftover -= bits;
                }
            } else {
                int leftover = j;
                for (int k = 0; k < b.length; ++k) {
                    long w = b[k];
                    if (w == 0L) continue;
                    int bits = Long.bitCount(w);
                    if (bits > leftover) {
                        return (char)(k * 64 + Util.select(w, leftover));
                    }
                    leftover -= bits;
                }
            }
        } else {
            int len = this.bitmap.limit();
            if (this.cardinality >>> 1 < j && j < this.cardinality) {
                int leftover = this.cardinality - j;
                for (int k = len - 1; k >= 0; --k) {
                    int w = Long.bitCount(this.bitmap.get(k));
                    if (w >= leftover) {
                        return (char)(k * 64 + Util.select(this.bitmap.get(k), w - leftover));
                    }
                    leftover -= w;
                }
            } else {
                int leftover = j;
                for (int k = 0; k < len; ++k) {
                    long X = this.bitmap.get(k);
                    int w = Long.bitCount(X);
                    if (w > leftover) {
                        return (char)(k * 64 + Util.select(X, leftover));
                    }
                    leftover -= w;
                }
            }
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    public char selectOneSide(int j) {
        int leftover = j;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int w = Long.bitCount(b[k]);
                if (w > leftover) {
                    return (char)(k * 64 + Util.select(b[k], leftover));
                }
                leftover -= w;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long X = this.bitmap.get(k);
                int w = Long.bitCount(X);
                if (w > leftover) {
                    return (char)(k * 64 + Util.select(X, leftover));
                }
                leftover -= w;
            }
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableBitmapContainer.serializedSizeInBytes(0);
    }

    MappeableArrayContainer toArrayContainer() {
        MappeableArrayContainer ac = new MappeableArrayContainer(this.cardinality);
        ac.loadData(this);
        if (ac.getCardinality() != this.cardinality) {
            throw new RuntimeException("Internal error.");
        }
        return ac;
    }

    @Override
    public Container toContainer() {
        return new BitmapContainer(this);
    }

    public long[] toLongArray() {
        long[] answer = new long[this.bitmap.limit()];
        this.bitmap.rewind();
        this.bitmap.get(answer);
        return answer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{}".length() + "-123456789,".length() * 256);
        PeekableCharIterator i = this.getCharIterator();
        sb.append('{');
        while (i.hasNext()) {
            sb.append((int)i.next());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        int len = this.bitmap.limit();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < len; ++k) {
                out.writeLong(Long.reverseBytes(b[k]));
            }
        } else {
            for (int k = 0; k < len; ++k) {
                long w = this.bitmap.get(k);
                out.writeLong(Long.reverseBytes(w));
            }
        }
    }

    @Override
    protected void writeArray(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        LongBuffer buf = this.bitmap.duplicate();
        buf.position(0);
        buffer.asLongBuffer().put(buf);
        buffer.position(buffer.position() + buf.position() * 8);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            char[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                char vc = v2[k];
                long mask = 1L << vc;
                int index = vc >>> 6;
                long ba = bitArray[index];
                answer.cardinality += 1 - 2 * (int)((ba & mask) >>> vc);
                bitArray[index] = ba ^ mask;
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                char v2 = value2.content.get(k);
                long mask = 1L << v2;
                int index = v2 >>> 6;
                long ba = bitArray[index];
                answer.cardinality += 1 - 2 * (int)((ba & mask) >>> v2);
                bitArray[index] = ba ^ mask;
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(b[k] ^ v2[k]);
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) ^ value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                int len3 = answer.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = b[k3] ^ v2[k3];
                }
            } else {
                len = answer.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) ^ value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer xor(MappeableRunContainer value2) {
        return value2.xor(this);
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int x = 0; x < b.length; ++x) {
                for (long w = b[x]; w != 0L; w &= w - 1L) {
                    ic.accept(x * 64 + Long.numberOfTrailingZeros(w) | high);
                }
            }
        } else {
            int l = this.bitmap.limit();
            for (int x = 0; x < l; ++x) {
                for (long w = this.bitmap.get(x); w != 0L; w &= w - 1L) {
                    ic.accept(x * 64 + Long.numberOfTrailingZeros(w) | high);
                }
            }
        }
    }

    @Override
    public int andCardinality(MappeableArrayContainer value2) {
        int answer = 0;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            char v = value2.content.get(k);
            answer += (int)this.bitValue(v);
        }
        return answer;
    }

    @Override
    public int andCardinality(MappeableBitmapContainer value2) {
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b1 = this.bitmap.array();
            long[] b2 = value2.bitmap.array();
            for (int k = 0; k < b1.length; ++k) {
                newCardinality += Long.bitCount(b1[k] & b2[k]);
            }
        } else {
            int size = this.bitmap.limit();
            for (int k = 0; k < size; ++k) {
                newCardinality += Long.bitCount(this.bitmap.get(k) & value2.bitmap.get(k));
            }
        }
        return newCardinality;
    }

    @Override
    public int andCardinality(MappeableRunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public MappeableBitmapContainer toBitmapContainer() {
        return this;
    }

    @Override
    public int first() {
        long firstNonZeroWord;
        this.assertNonEmpty(this.cardinality == 0);
        int i = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] array = this.bitmap.array();
            while (array[i] == 0L) {
                ++i;
            }
            firstNonZeroWord = array[i];
        } else {
            i = this.bitmap.position();
            while (this.bitmap.get(i) == 0L) {
                ++i;
            }
            firstNonZeroWord = this.bitmap.get(i);
        }
        return i * 64 + Long.numberOfTrailingZeros(firstNonZeroWord);
    }

    @Override
    public int last() {
        long lastNonZeroWord;
        int i;
        this.assertNonEmpty(this.cardinality == 0);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] array = this.bitmap.array();
            for (i = this.bitmap.limit() - 1; i > 0 && array[i] == 0L; --i) {
            }
            lastNonZeroWord = array[i];
        } else {
            while (i > 0 && this.bitmap.get(i) == 0L) {
                --i;
            }
            lastNonZeroWord = this.bitmap.get(i);
        }
        return (i + 1) * 64 - Long.numberOfLeadingZeros(lastNonZeroWord) - 1;
    }

    @Override
    public int nextValue(char fromValue) {
        return this.nextSetBit(fromValue);
    }

    @Override
    public int previousValue(char fromValue) {
        return this.prevSetBit(fromValue);
    }

    @Override
    public int nextAbsentValue(char fromValue) {
        return this.nextClearBit(fromValue);
    }

    @Override
    public int previousAbsentValue(char fromValue) {
        return this.prevClearBit(fromValue);
    }

    @Override
    protected boolean contains(MappeableBitmapContainer bitmapContainer) {
        if (this.cardinality != -1 && bitmapContainer.cardinality != -1 && this.cardinality < bitmapContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < 1024; ++i) {
            if ((this.bitmap.get(i) & bitmapContainer.bitmap.get(i)) == bitmapContainer.bitmap.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        int start2 = minimum >>> 6;
        int end = supremum >>> 6;
        if (start2 == end) {
            return (this.bitmap.get(start2) & (-(1L << minimum) & (1L << supremum) - 1L)) != 0L;
        }
        if ((this.bitmap.get(start2) & -(1L << minimum)) != 0L) {
            return true;
        }
        if (end < this.bitmap.limit() && (this.bitmap.get(end) & (1L << supremum) - 1L) != 0L) {
            return true;
        }
        for (int i = 1 + start2; i < end && i < this.bitmap.limit(); ++i) {
            if (this.bitmap.get(i) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int minimum, int supremum) {
        int start2 = minimum >>> 6;
        int end = supremum >>> 6;
        long first = -(1L << minimum);
        long last = (1L << supremum) - 1L;
        if (start2 == end) {
            return (this.bitmap.get(end) & first & last) == (first & last);
        }
        if ((this.bitmap.get(start2) & first) != first) {
            return false;
        }
        if (end < this.bitmap.limit() && (this.bitmap.get(end) & last) != last) {
            return false;
        }
        for (int i = start2 + 1; i < this.bitmap.limit() && i < end; ++i) {
            if (this.bitmap.get(i) == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(MappeableRunContainer runContainer) {
        int card;
        int runCardinality = runContainer.getCardinality();
        if (this.cardinality != -1 ? this.cardinality < runCardinality : (card = this.cardinality) < runCardinality) {
            return false;
        }
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            char length;
            char start2 = runContainer.getValue(i);
            if (this.contains(start2, start2 + (length = runContainer.getLength(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(MappeableArrayContainer arrayContainer) {
        if (arrayContainer.cardinality != -1 && this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < arrayContainer.cardinality; ++i) {
            if (this.contains(arrayContainer.content.get(i))) continue;
            return false;
        }
        return true;
    }
}

