/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap.buffer;

import java.nio.CharBuffer;
import org.apache.celeborn.shaded.org.roaringbitmap.ContainerBatchIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;

public final class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private MappeableArrayContainer array;

    public ArrayBatchIterator(MappeableArrayContainer array) {
        this.wrap(array);
    }

    @Override
    public int next(int key, int[] buffer, int offset) {
        int consumed = 0;
        CharBuffer data = this.array.content;
        while (offset + consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[offset + consumed++] = key + data.get(this.index++);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void releaseContainer() {
        this.array = null;
    }

    @Override
    public void advanceIfNeeded(char target) {
        int position = BufferUtil.unsignedBinarySearch(this.array.content, 0, this.array.getCardinality(), target);
        this.index = position < 0 ? -position - 1 : position;
    }

    public void wrap(MappeableArrayContainer array) {
        this.array = array;
        this.index = 0;
    }
}

