/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.Map;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteShuffleInputGateFactory {
    public static final int MIN_BUFFERS_PER_GATE = 16;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteShuffleInputGateFactory.class);
    protected final int numConcurrentReading;
    protected final int networkBufferSize;
    protected final NetworkBufferPool networkBufferPool;
    protected final int numBuffersPerGate;
    protected boolean supportFloatingBuffers;
    protected CelebornConf celebornConf;

    public AbstractRemoteShuffleInputGateFactory(CelebornConf conf, NetworkBufferPool networkBufferPool, int networkBufferSize) {
        this.celebornConf = conf;
        this.numBuffersPerGate = Utils.checkedDownCast(this.celebornConf.clientFlinkMemoryPerInputGate() / (long)networkBufferSize);
        if (this.numBuffersPerGate < 16) {
            throw new IllegalArgumentException(String.format("Insufficient network memory per input gate, please increase %s to at least %d bytes.", CelebornConf.CLIENT_MEMORY_PER_INPUT_GATE().key(), networkBufferSize * 16));
        }
        this.supportFloatingBuffers = this.celebornConf.clientFlinkInputGateSupportFloatingBuffer();
        this.networkBufferSize = networkBufferSize;
        this.numConcurrentReading = this.celebornConf.clientFlinkNumConcurrentReading();
        this.networkBufferPool = networkBufferPool;
    }

    public IndexedInputGate create(ShuffleIOOwnerContext ownerContext, int gateIndex, InputGateDeploymentDescriptor igdd, Map<Integer, ShuffleIOMetricGroup> shuffleIOMetricGroups) {
        LOG.info("Create input gate -- number of buffers per input gate={}, number of concurrent readings={}.", (Object)this.numBuffersPerGate, (Object)this.numConcurrentReading);
        SupplierWithException<BufferPool, IOException> bufferPoolFactory = this.createBufferPoolFactory((BufferPoolFactory)this.networkBufferPool, this.numBuffersPerGate, this.supportFloatingBuffers);
        return this.createInputGate(ownerContext, gateIndex, igdd, bufferPoolFactory, this.celebornConf.shuffleCompressionCodec().name(), shuffleIOMetricGroups);
    }

    protected abstract IndexedInputGate createInputGate(ShuffleIOOwnerContext var1, int var2, InputGateDeploymentDescriptor var3, SupplierWithException<BufferPool, IOException> var4, String var5, Map<Integer, ShuffleIOMetricGroup> var6);

    private SupplierWithException<BufferPool, IOException> createBufferPoolFactory(BufferPoolFactory bufferPoolFactory, int numBuffers, boolean supportFloatingBuffers) {
        if (supportFloatingBuffers) {
            return () -> bufferPoolFactory.createBufferPool(1, numBuffers);
        }
        return () -> bufferPoolFactory.createBufferPool(numBuffers, numBuffers);
    }
}

