/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.utils.UUIDGen;

public abstract class AbstractTimeUUID extends UUID
{
    @Override
    public String name()
    {
        return "timeuuid";
    }

    @Override
    public AbstractType<?> dataType()
    {
        return TimeUUIDType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize)
    {
        return UUIDGen.getTimeUUID();
    }

    @Override
    public DataType driverDataType(boolean isFrozen)
    {
        return DataType.timeuuid();
    }
}
