/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common;

import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import org.apache.cassandra.spark.common.SidecarInstanceFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SidecarInstanceFactoryTest {
    SidecarInstanceFactoryTest() {
    }

    @Test
    void testCreateSidecarInstance() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SidecarInstanceFactory.createFromString((String)"", (int)9999)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Unable to create sidecar instance from empty input");
        this.assertSidecarInstance((SidecarInstance)SidecarInstanceFactory.createFromString((String)"localhost", (int)9999), "localhost", 9999);
        this.assertSidecarInstance((SidecarInstance)SidecarInstanceFactory.createFromString((String)"[2024:a::1]", (int)9999), "[2024:a::1]", 9999);
        this.assertSidecarInstance((SidecarInstance)SidecarInstanceFactory.createFromString((String)"localhost:8888", (int)9999), "localhost", 8888);
        this.assertSidecarInstance((SidecarInstance)SidecarInstanceFactory.createFromString((String)"127.0.0.1:8888", (int)9999), "127.0.0.1", 8888);
        this.assertSidecarInstance((SidecarInstance)SidecarInstanceFactory.createFromString((String)"[2024:a::1]:8888", (int)9999), "[2024:a::1]", 8888);
    }

    private void assertSidecarInstance(SidecarInstance sidecarInstance, String expectedHostname, int expectedPort) {
        Assertions.assertThat((String)sidecarInstance.hostname()).isEqualTo(expectedHostname);
        Assertions.assertThat((int)sidecarInstance.port()).isEqualTo(expectedPort);
    }
}

