/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.clients;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.cassandra.clients.AnalyticsSidecarClient;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SidecarClientConfigTest {
    @Test
    public void testDefaults() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of());
        Assertions.assertThat((int)clientConfig.userProvidedPort()).isEqualTo(-1);
        Assertions.assertThat((int)clientConfig.effectivePort()).isEqualTo(9043);
        Assertions.assertThat((int)clientConfig.maxRetries()).isEqualTo(10);
        Assertions.assertThat((long)clientConfig.millisToSleep()).isEqualTo(500L);
        Assertions.assertThat((long)clientConfig.maxMillisToSleep()).isEqualTo(60000L);
        Assertions.assertThat((long)clientConfig.maxBufferSize()).isEqualTo(0x600000L);
        Assertions.assertThat((long)clientConfig.chunkBufferSize()).isEqualTo(0x400000L);
        Assertions.assertThat((int)clientConfig.maxPoolSize()).isEqualTo(64);
        Assertions.assertThat((int)clientConfig.timeoutSeconds()).isEqualTo(600);
    }

    @Test
    public void testSidecarPort() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"sidecar_port", (Object)"9999"));
        Assertions.assertThat((int)clientConfig.userProvidedPort()).isEqualTo(9999);
        Assertions.assertThat((int)clientConfig.effectivePort()).isEqualTo(9999);
    }

    @Test
    public void testMaxRetries() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"maxretries", (Object)"5"));
        Assertions.assertThat((int)clientConfig.maxRetries()).isEqualTo(5);
    }

    @Test
    public void testMillisToSleep() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"defaultmillistosleep", (Object)"5000"));
        Assertions.assertThat((long)clientConfig.millisToSleep()).isEqualTo(5000L);
    }

    @Test
    public void testMaxMillisToSleep() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"maxmillistosleep", (Object)"30000"));
        Assertions.assertThat((long)clientConfig.maxMillisToSleep()).isEqualTo(30000L);
    }

    @Test
    public void testMaxBufferSize() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"maxbuffersizebytes", (Object)"8"));
        Assertions.assertThat((long)clientConfig.maxBufferSize()).isEqualTo(8L);
    }

    @Test
    public void testChunkBufferSize() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"chunkbuffersizebytes", (Object)"24"));
        Assertions.assertThat((long)clientConfig.chunkBufferSize()).isEqualTo(24L);
    }

    @Test
    public void testMaxPoolSize() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"maxpoolsize", (Object)"150"));
        Assertions.assertThat((int)clientConfig.maxPoolSize()).isEqualTo(150);
    }

    @Test
    public void testTimeoutSeconds() {
        Sidecar.ClientConfig clientConfig = Sidecar.ClientConfig.create((Map)ImmutableMap.of((Object)"timeoutseconds", (Object)"2"));
        Assertions.assertThat((int)clientConfig.timeoutSeconds()).isEqualTo(2);
    }

    @Test
    public void testTransportModeBasedWriterUserAgent() {
        String userAgentStr = AnalyticsSidecarClient.transportModeBasedWriterUserAgent((DataTransport)DataTransport.DIRECT);
        Assertions.assertThat((boolean)userAgentStr.endsWith(" writer")).isTrue();
        userAgentStr = AnalyticsSidecarClient.transportModeBasedWriterUserAgent((DataTransport)DataTransport.S3_COMPAT);
        Assertions.assertThat((boolean)userAgentStr.endsWith(" writer-s3")).isTrue();
    }
}

