/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common.schema;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.common.schema.CollectionType;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.common.schema.ColumnUtil;
import org.jetbrains.annotations.NotNull;

public class ListType<T>
extends CollectionType<T, CQLListEntry<T>> {
    public final ColumnType<T> elementType;

    public ListType(ColumnType<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public CQLListEntry<T> parseCollectionColumn(ByteBuffer colNameSuffix, ByteBuffer colValue) {
        return new CQLListEntry<T>(ColumnUtil.getField(colNameSuffix, ColumnTypes.UUID), ColumnUtil.parseSingleColumn(this.elementType, colValue));
    }

    @Override
    public List<T> finaliseCollection(List<CQLListEntry<T>> entryList) {
        Collections.sort(entryList);
        return entryList.stream().map(entry -> entry.value).collect(Collectors.toList());
    }

    public static class CQLListEntry<T>
    implements Comparable<CQLListEntry<T>> {
        private final UUID timeUUID;
        public final T value;

        @Override
        public int compareTo(@NotNull CQLListEntry that) {
            return this.timeUUID.compareTo(that.timeUUID);
        }

        CQLListEntry(UUID timeUUID, T value) {
            this.timeUUID = timeUUID;
            this.value = value;
        }
    }
}

