/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.testcontainer;

import com.google.inject.Injector;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.analytics.SparkTestUtils;
import org.apache.cassandra.analytics.SparkTestUtilsProvider;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.testing.LocalhostResolver;
import org.apache.cassandra.sidecar.testing.MtlsTestHelper;
import org.apache.cassandra.testing.IsolatedDTestClassLoaderWrapper;
import org.apache.cassandra.testing.TestVersion;
import org.apache.cassandra.testing.TestVersionSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class CoordinatedWriteTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedWriteTestBase.class);
    @TempDir
    static Path secretsPath;
    protected MtlsTestHelper mtlsTestHelper;
    protected IsolatedDTestClassLoaderWrapper classLoaderWrapper;
    protected DnsResolver dnsResolver = new LocalhostResolver();
    protected Injector sidecarServerInjector;
    protected SparkTestUtils sparkTestUtils = SparkTestUtilsProvider.utils();
    protected TestVersion testVersion;

    @BeforeAll
    protected void setup() throws Exception {
        Optional maybeTestVersion = TestVersionSupplier.testVersions().findFirst();
        Assertions.assertThat(maybeTestVersion).isPresent();
        this.testVersion = (TestVersion)maybeTestVersion.get();
        LOGGER.info("Testing with version={}", (Object)this.testVersion);
        this.classLoaderWrapper = new IsolatedDTestClassLoaderWrapper();
        this.classLoaderWrapper.initializeDTestJarClassLoader(this.testVersion, TestVersion.class);
        this.mtlsTestHelper = new MtlsTestHelper(secretsPath);
        this.sparkTestUtils.setMtlsTestHelper(this.mtlsTestHelper);
    }

    protected void stopSidecarServers(Server ... servers) throws InterruptedException {
        CountDownLatch closeLatch = new CountDownLatch(servers.length);
        for (Server server : servers) {
            server.close().onSuccess(res -> closeLatch.countDown());
        }
        if (closeLatch.await(60L, TimeUnit.SECONDS)) {
            LOGGER.info("Close event received before timeout.");
        } else {
            LOGGER.error("Close event timed out.");
        }
    }
}

