/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class QualifiedTableName {
    @NotNull
    private final String keyspace;
    @NotNull
    private final String table;
    private final boolean quoteIdentifiers;

    public QualifiedTableName(String keyspace, String tableName, boolean quoteIdentifiers) {
        this.keyspace = Objects.requireNonNull(keyspace);
        this.table = Objects.requireNonNull(tableName);
        this.quoteIdentifiers = quoteIdentifiers;
    }

    public QualifiedTableName(String keyspace, String tableName) {
        this(keyspace, tableName, false);
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public boolean quoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public String toString() {
        return this.maybeQuote(this.keyspace) + "." + this.maybeQuote(this.table);
    }

    private String maybeQuote(String name) {
        if (this.quoteIdentifiers) {
            return "\"" + name + "\"";
        }
        return name;
    }
}

