/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.json;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroDataUtils;
import org.apache.cassandra.cdc.avro.CdcEventAvroEncoder;
import org.apache.cassandra.cdc.avro.CdcEventUtils;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;

public class AvroJsonTransformer
extends CdcEventAvroEncoder {
    public AvroJsonTransformer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        super(schemaStore, typeLookup, "cdc_bytes.avsc");
    }

    @Override
    public GenericData.Record transform(CdcEvent event) {
        GenericData.Record payload = this.transformPayload(event, this.typeLookup);
        GenericData.Record record = new GenericData.Record(this.cdcSchema);
        Function<Value, Object> avroFieldEncoder = field -> {
            Schema tableSchema = this.store.getSchema(event.keyspace + "." + event.table, null);
            GenericData.Record update = new GenericData.Record(tableSchema);
            CqlField.CqlType type = (CqlField.CqlType)this.typeLookup.apply(KeyspaceTypeKey.of((String)event.keyspace, (String)field.columnType));
            Object javaValue = type.deserializeToJavaType(field.getValue());
            update.put(field.columnName, AvroDataUtils.toAvro(javaValue, tableSchema.getField(field.columnName).schema()));
            return ByteBuffer.wrap(this.encode(this.store.getWriter(event.keyspace + "." + event.table, null), update));
        };
        record.put("payload", (Object)payload);
        this.applyCommonFields(event, record, avroFieldEncoder);
        return record;
    }

    private GenericData.Record transformPayload(CdcEvent event, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        Schema tableSchema = this.store.getSchema(event.keyspace + "." + event.table, null);
        GenericData.Record update = new GenericData.Record(tableSchema);
        CdcEventUtils.updatedFields(event).forEach(field -> {
            CqlField.CqlType type = (CqlField.CqlType)typeLookup.apply(KeyspaceTypeKey.of((String)event.keyspace, (String)field.columnType));
            Object javaValue = type.deserializeToJavaType(field.getValue());
            update.put(field.columnName, AvroDataUtils.toAvro(javaValue, tableSchema.getField(field.columnName).schema()));
        });
        return update;
    }
}

