/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InOurDc;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosRequestCallback;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.ConditionAsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosCommit<OnDone extends Consumer<? super Status>>
extends PaxosRequestCallback<NoPayload> {
    public static final RequestHandler requestHandler = new RequestHandler();
    private static final Logger logger = LoggerFactory.getLogger(PaxosCommit.class);
    private static volatile boolean ENABLE_DC_LOCAL_COMMIT = CassandraRelevantProperties.ENABLE_DC_LOCAL_COMMIT.getBoolean();
    private static final Status success = new Status(null);
    private static final AtomicLongFieldUpdater<PaxosCommit> responsesUpdater = AtomicLongFieldUpdater.newUpdater(PaxosCommit.class, "responses");
    final Commit.Agreed commit;
    final boolean allowHints;
    final ConsistencyLevel consistencyForConsensus;
    final ConsistencyLevel consistencyForCommit;
    final EndpointsForToken replicas;
    final int required;
    final OnDone onDone;
    private volatile long responses;

    public static boolean getEnableDcLocalCommit() {
        return ENABLE_DC_LOCAL_COMMIT;
    }

    public static void setEnableDcLocalCommit(boolean enableDcLocalCommit) {
        ENABLE_DC_LOCAL_COMMIT = enableDcLocalCommit;
    }

    public PaxosCommit(Commit.Agreed commit, boolean allowHints, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, Paxos.Participants participants, OnDone onDone) {
        this.commit = commit;
        this.allowHints = allowHints;
        this.consistencyForConsensus = consistencyForConsensus;
        this.consistencyForCommit = consistencyForCommit;
        this.replicas = participants.all;
        this.onDone = onDone;
        this.required = participants.requiredFor(consistencyForCommit);
        if (this.required == 0) {
            onDone.accept((Status)this.status());
        }
    }

    static Paxos.Async<Status> commit(Commit.Agreed commit, Paxos.Participants participants, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, @Deprecated(since="4.1") boolean allowHints) {
        class Async
        extends PaxosCommit<ConditionAsConsumer<Status>>
        implements Paxos.Async<Status> {
            private Async(Commit.Agreed commit, boolean allowHints, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, Paxos.Participants participants) {
                super(commit, allowHints, consistencyForConsensus, consistencyForCommit, participants, ConditionAsConsumer.newConditionAsConsumer());
            }

            @Override
            public Status awaitUntil(long deadline) {
                try {
                    ((ConditionAsConsumer)this.onDone).awaitUntil(deadline);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return new Status(new Paxos.MaybeFailure(true, this.replicas.size(), this.required, 0, Collections.emptyMap()));
                }
                return this.status();
            }
        }
        Async async = new Async(commit, allowHints, consistencyForConsensus, consistencyForCommit, participants);
        async.start(participants, false);
        return async;
    }

    static <T extends Consumer<Status>> T commit(Commit.Agreed commit, Paxos.Participants participants, ConsistencyLevel consistencyForConsensus, ConsistencyLevel consistencyForCommit, @Deprecated(since="4.1") boolean allowHints, T onDone) {
        new PaxosCommit<T>(commit, allowHints, consistencyForConsensus, consistencyForCommit, participants, onDone).start(participants, true);
        return onDone;
    }

    void start(Paxos.Participants participants, boolean async) {
        int i;
        boolean executeOnSelf = false;
        Message<Commit.Agreed> commitMessage = Message.out(Verb.PAXOS_COMMIT_REQ, this.commit);
        Message<Mutation> mutationMessage = ENABLE_DC_LOCAL_COMMIT && this.consistencyForConsensus.isDatacenterLocal() ? Message.out(Verb.PAXOS2_COMMIT_REMOTE_REQ, this.commit.makeMutation()) : null;
        int mi = participants.allLive.size();
        for (i = 0; i < mi; ++i) {
            executeOnSelf |= this.isSelfOrSend(commitMessage, mutationMessage, participants.allLive.endpoint(i));
        }
        mi = participants.allDown.size();
        for (i = 0; i < mi; ++i) {
            this.onFailure(participants.allDown.endpoint(i), RequestFailureReason.NODE_DOWN);
        }
        if (executeOnSelf) {
            ExecutorPlus executor = Verb.PAXOS_COMMIT_REQ.stage.executor();
            if (async) {
                executor.execute(this::executeOnSelf);
            } else {
                executor.maybeExecuteImmediately(this::executeOnSelf);
            }
        }
    }

    private boolean isSelfOrSend(Message<Commit.Agreed> commitMessage, Message<Mutation> mutationMessage, InetAddressAndPort destination) {
        if (PaxosCommit.shouldExecuteOnSelf(destination)) {
            return true;
        }
        if (mutationMessage != null && !PaxosCommit.isInLocalDc(destination)) {
            MessagingService.instance().sendWithCallback(mutationMessage, destination, (RequestCallback)this);
        } else {
            MessagingService.instance().sendWithCallback(commitMessage, destination, (RequestCallback)this);
        }
        return false;
    }

    private static boolean isInLocalDc(InetAddressAndPort destination) {
        return DatabaseDescriptor.getLocalDataCenter().equals(DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination));
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} {} from {}", new Object[]{this.commit, reason, from});
        }
        this.response(false, from);
        Replica replica = this.replicas.lookup(from);
        if (this.allowHints && StorageProxy.shouldHint(replica)) {
            StorageProxy.submitHint(this.commit.makeMutation(), replica, null);
        }
    }

    @Override
    public void onResponse(Message<NoPayload> response) {
        logger.trace("{} Success from {}", (Object)this.commit, (Object)response.from());
        this.response(true, response.from());
    }

    public void executeOnSelf() {
        this.executeOnSelf(this.commit, (x$0, x$1) -> RequestHandler.execute(x$0, x$1));
    }

    @Override
    public void onResponse(NoPayload response, InetAddressAndPort from) {
        this.response(response != null, from);
    }

    private void response(boolean success, InetAddressAndPort from) {
        if (this.consistencyForCommit.isDatacenterLocal() && !InOurDc.endpoints().test(from)) {
            return;
        }
        long responses = responsesUpdater.addAndGet(this, success ? 1L : 0x100000000L);
        if (PaxosCommit.accepts(responses) == this.required) {
            this.onDone.accept((Status)this.status());
        } else if (this.replicas.size() - PaxosCommit.failures(responses) == this.required - 1) {
            this.onDone.accept((Status)this.status());
        }
    }

    Status status() {
        long responses = this.responses;
        if (this.isSuccessful(responses)) {
            return success;
        }
        return new Status(new Paxos.MaybeFailure(this.replicas.size(), this.required, PaxosCommit.accepts(responses), this.failureReasonsAsMap()));
    }

    private boolean isSuccessful(long responses) {
        return PaxosCommit.accepts(responses) >= this.required;
    }

    private static int accepts(long responses) {
        return (int)(responses & 0xFFFFFFFFL);
    }

    private static int failures(long responses) {
        return (int)(responses >>> 32);
    }

    public static class RequestHandler
    implements IVerbHandler<Commit.Agreed> {
        @Override
        public void doVerb(Message<Commit.Agreed> message) {
            NoPayload response = RequestHandler.execute((Commit.Agreed)message.payload, message.from());
            if (response == null) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
            } else {
                MessagingService.instance().respond(response, message);
            }
        }

        private static NoPayload execute(Commit.Agreed agreed, InetAddressAndPort from) {
            if (!Paxos.isInRangeAndShouldProcess(from, agreed.update.partitionKey(), agreed.update.metadata(), false)) {
                return null;
            }
            PaxosState.commitDirect(agreed);
            Tracing.trace("Enqueuing acknowledge to {}", (Object)from);
            return NoPayload.noPayload;
        }
    }

    static class Status {
        private final Paxos.MaybeFailure maybeFailure;

        Status(Paxos.MaybeFailure maybeFailure) {
            this.maybeFailure = maybeFailure;
        }

        boolean isSuccess() {
            return this.maybeFailure == null;
        }

        Paxos.MaybeFailure maybeFailure() {
            return this.maybeFailure;
        }

        public String toString() {
            return this.maybeFailure == null ? "Success" : this.maybeFailure.toString();
        }
    }
}

