/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.metrics.CacheMetrics;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public class ChunkCacheMetrics
extends CacheMetrics
implements StatsCounter {
    public final Timer missLatency;

    public ChunkCacheMetrics(ChunkCache cache) {
        super("ChunkCache", cache);
        this.missLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("MissLatency"));
    }

    public void recordHits(int count) {
        this.requests.mark((long)count);
        this.hits.mark((long)count);
    }

    public void recordMisses(int count) {
        this.requests.mark((long)count);
        this.misses.mark((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.missLatency.update(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordLoadFailure(long loadTime) {
    }

    public void recordEviction(int weight, RemovalCause cause) {
    }

    @Nonnull
    public CacheStats snapshot() {
        return CacheStats.of((long)this.hits.getCount(), (long)this.misses.getCount(), (long)this.missLatency.getCount(), (long)0L, (long)this.missLatency.getCount(), (long)0L, (long)0L);
    }
}

