/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kserve.KServeComponent;

/**
 * Provide access to AI model servers with the KServe standard to run inference
 * with remote models
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface KserveComponentBuilderFactory {

    /**
     * KServe (camel-kserve)
     * Provide access to AI model servers with the KServe standard to run
     * inference with remote models
     * 
     * Category: ai
     * Since: 4.10
     * Maven coordinates: org.apache.camel:camel-kserve
     * 
     * @return the dsl builder
     */
    static KserveComponentBuilder kserve() {
        return new KserveComponentBuilderImpl();
    }

    /**
     * Builder for the KServe component.
     */
    interface KserveComponentBuilder extends ComponentBuilder<KServeComponent> {
    
        /**
         * The configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.kserve.KServeConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder configuration(org.apache.camel.component.kserve.KServeConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The name of the model used for inference.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param modelName the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder modelName(java.lang.String modelName) {
            doSetProperty("modelName", modelName);
            return this;
        }
    
        /**
         * The version of the model used for inference.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder modelVersion(java.lang.String modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
    
        
        /**
         * The target URI of the client. See:
         * https://grpc.github.io/grpc-java/javadoc/io/grpc/Grpc.html#newChannelBuilder%28java.lang.String,io.grpc.ChannelCredentials%29.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:8001
         * Group: common
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder target(java.lang.String target) {
            doSetProperty("target", target);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * The credentials of the client.
         * 
         * The option is a: &lt;code&gt;io.grpc.ChannelCredentials&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default KserveComponentBuilder credentials(io.grpc.ChannelCredentials credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    class KserveComponentBuilderImpl
            extends AbstractComponentBuilder<KServeComponent>
            implements KserveComponentBuilder {
        @Override
        protected KServeComponent buildConcreteComponent() {
            return new KServeComponent();
        }
        private org.apache.camel.component.kserve.KServeConfiguration getOrCreateConfiguration(KServeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.kserve.KServeConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((KServeComponent) component).setConfiguration((org.apache.camel.component.kserve.KServeConfiguration) value); return true;
            case "modelName": getOrCreateConfiguration((KServeComponent) component).setModelName((java.lang.String) value); return true;
            case "modelVersion": getOrCreateConfiguration((KServeComponent) component).setModelVersion((java.lang.String) value); return true;
            case "target": getOrCreateConfiguration((KServeComponent) component).setTarget((java.lang.String) value); return true;
            case "lazyStartProducer": ((KServeComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((KServeComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "healthCheckConsumerEnabled": ((KServeComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((KServeComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "credentials": getOrCreateConfiguration((KServeComponent) component).setCredentials((io.grpc.ChannelCredentials) value); return true;
            default: return false;
            }
        }
    }
}