/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;

public class SaslTestUtil
extends ClientBase {
    static Integer CLIENT_DISCONNECT_TIMEOUT = 3000;
    static String SUPER_USER_NAME = "super";
    static String requireSASLAuthProperty = "zookeeper.sessionRequireClientSASLAuth";
    static String authProviderProperty = "zookeeper.authProvider.1";
    static String authProvider = "org.apache.zookeeper.server.auth.SASLAuthenticationProvider";
    static String digestLoginModule = "org.apache.zookeeper.server.auth.DigestLoginModule";
    static String jaasConfig = "java.security.auth.login.config";

    static String createJAASConfigFile(String fileName, String password) {
        return SaslTestUtil.createJAASConfigFile(fileName, SUPER_USER_NAME, password);
    }

    static String createJAASConfigFile(String fileName, String userName, String password) {
        String ret = null;
        try {
            File tmpDir = SaslTestUtil.createTmpDir();
            File jaasFile = new File(tmpDir, fileName);
            FileWriter fwriter = new FileWriter(jaasFile);
            fwriter.write("Server {\n          " + digestLoginModule + " required\n          user_super=\"test\";\n};\nClient {\n       " + digestLoginModule + " required\n       username=\"" + userName + "\"\n       password=\"" + password + "\";\n};\n");
            fwriter.close();
            ret = jaasFile.getAbsolutePath();
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to create JaaS configuration file!");
        }
        return ret;
    }
}

