/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;

class GetListOfEntriesOfLedgerCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.GetListOfEntriesOfLedgerCallback cb;

    public GetListOfEntriesOfLedgerCompletion(CompletionKey key, BookkeeperInternalCallbacks.GetListOfEntriesOfLedgerCallback origCallback, long ledgerId, PerChannelBookieClient perChannelBookieClient) {
        super("GetListOfEntriesOfLedger", null, ledgerId, 0L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.getListOfEntriesOfLedgerCompletionOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.getListOfEntriesOfLedgerCompletionTimeoutOpLogger;
        this.cb = (rc, ledgerId1, availabilityOfEntriesOfLedger) -> {
            this.logOpResult(rc);
            origCallback.getListOfEntriesOfLedgerComplete(rc, ledgerId1, availabilityOfEntriesOfLedger);
            key.release();
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.getListOfEntriesOfLedgerComplete(rc, this.ledgerId, null));
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.StatusCode status;
        BookkeeperProtocol.GetListOfEntriesOfLedgerResponse getListOfEntriesOfLedgerResponse = response.getGetListOfEntriesOfLedgerResponse();
        ByteBuf availabilityOfEntriesOfLedgerBuffer = Unpooled.EMPTY_BUFFER;
        BookkeeperProtocol.StatusCode statusCode = status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? getListOfEntriesOfLedgerResponse.getStatus() : response.getStatus();
        if (getListOfEntriesOfLedgerResponse.hasAvailabilityOfEntriesOfLedger()) {
            availabilityOfEntriesOfLedgerBuffer = Unpooled.wrappedBuffer((ByteBuffer)getListOfEntriesOfLedgerResponse.getAvailabilityOfEntriesOfLedger().asReadOnlyByteBuffer());
        }
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledgerId", this.ledgerId);
        }
        int rc = this.convertStatus(status, -1);
        AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = null;
        if (rc == 0) {
            availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(availabilityOfEntriesOfLedgerBuffer.slice());
        }
        this.cb.getListOfEntriesOfLedgerComplete(rc, this.ledgerId, availabilityOfEntriesOfLedger);
    }
}

