/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.util.Objects;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class FixedSizeStringLogicalType
extends LogicalType {
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private final Integer minLength;
    private final Integer maxLength;

    public FixedSizeStringLogicalType() {
        super("fixed-size-string");
        this.minLength = Integer.MIN_VALUE;
        this.maxLength = Integer.MAX_VALUE;
    }

    public FixedSizeStringLogicalType(Schema schema) {
        super("fixed-size-string");
        this.minLength = this.getInteger(schema, MIN_LENGTH);
        this.maxLength = this.getInteger(schema, MAX_LENGTH);
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    private int getInteger(Schema schema, String name) {
        Object value = schema.getObjectProp(name);
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException(String.format("Invalid %s: missing %s", "fixed-size-string", name));
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException(String.format("Expected integer %s but get %s", name, value.getClass().getSimpleName()));
    }
}

