/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.util.SimpleLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSCache
extends ConcurrentHashMap<String, List<DNSEntry>> {
    private static final long serialVersionUID = 3024739453186759259L;
    private final Logger logger = LoggerFactory.getLogger(DNSCache.class);
    private final transient SimpleLockManager _lm = new SimpleLockManager();

    public DNSCache() {
        this(1024);
    }

    public DNSCache(DNSCache map) {
        this(map != null ? map.size() : 1024);
        if (map != null) {
            this.putAll(map);
        }
    }

    public DNSCache(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new DNSCache(this);
    }

    public Collection<DNSEntry> allValues() {
        ArrayList<DNSEntry> allValues = new ArrayList<DNSEntry>();
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (entry == null) continue;
            String key = (String)entry.getKey();
            SimpleLockManager.Locked lock = this._lm.lock(key);
            Throwable throwable = null;
            try {
                List entryList = (List)entry.getValue();
                if (entryList == null) continue;
                allValues.addAll(entryList);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
        return allValues;
    }

    public Collection<? extends DNSEntry> getDNSEntryList(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        String key = name.toLowerCase();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            List<DNSEntry> entryList = this.getEntryListOrEmpty(key);
            if (entryList.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            ArrayList<DNSEntry> arrayList = new ArrayList<DNSEntry>(entryList);
            return arrayList;
        }
    }

    public DNSEntry getDNSEntry(DNSEntry dnsEntry) {
        if (dnsEntry == null) {
            return null;
        }
        String key = dnsEntry.getKey();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            List<DNSEntry> entryList = this.getEntryListOrEmpty(key);
            for (DNSEntry testDNSEntry : entryList) {
                if (!testDNSEntry.isSameEntry(dnsEntry)) continue;
                DNSEntry dNSEntry = testDNSEntry;
                return dNSEntry;
            }
        }
        return null;
    }

    public DNSEntry getDNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass) {
        if (name == null) {
            return null;
        }
        String key = name.toLowerCase();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            List<DNSEntry> entryList = this.getEntryListOrEmpty(key);
            for (DNSEntry testDNSEntry : entryList) {
                if (!testDNSEntry.matchRecordType(type) || !testDNSEntry.matchRecordClass(recordClass)) continue;
                DNSEntry dNSEntry = testDNSEntry;
                return dNSEntry;
            }
        }
        return null;
    }

    public Collection<? extends DNSEntry> getDNSEntryList(String name, DNSRecordType type, DNSRecordClass recordClass) {
        ArrayList<DNSEntry> result;
        if (name == null) {
            return Collections.emptyList();
        }
        String key = name.toLowerCase();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            List<DNSEntry> entryList = this.getEntryListOrEmpty(key);
            result = new ArrayList<DNSEntry>(entryList);
        }
        result.removeIf(testDNSEntry -> !testDNSEntry.matchRecordType(type) || !testDNSEntry.matchRecordClass(recordClass));
        return result;
    }

    public boolean addDNSEntry(DNSEntry dnsEntry) {
        if (dnsEntry == null) {
            return false;
        }
        String key = dnsEntry.getKey();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            ArrayList<DNSEntry> entryList = (ArrayList<DNSEntry>)this.get(key);
            if (entryList == null) {
                entryList = new ArrayList<DNSEntry>(3);
            }
            entryList.add(dnsEntry);
            this.put(key, entryList);
        }
        return true;
    }

    public boolean removeDNSEntry(DNSEntry dnsEntry) {
        if (dnsEntry == null) {
            return false;
        }
        String key = dnsEntry.getKey();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            List entryList = (List)this.get(key);
            if (entryList == null) {
                boolean bl = false;
                return bl;
            }
            boolean result = entryList.remove(dnsEntry);
            if (entryList.isEmpty()) {
                this.remove(key);
            } else {
                this.put(key, entryList);
            }
            boolean bl = result;
            return bl;
        }
    }

    public boolean replaceDNSEntry(DNSEntry newDNSEntry, DNSEntry existingDNSEntry) {
        if (newDNSEntry == null || existingDNSEntry == null || !newDNSEntry.getKey().equals(existingDNSEntry.getKey())) {
            return false;
        }
        String key = newDNSEntry.getKey();
        try (SimpleLockManager.Locked lock = this._lm.lock(key);){
            ArrayList<DNSEntry> entryList = (ArrayList<DNSEntry>)this.get(key);
            if (entryList == null) {
                entryList = new ArrayList<DNSEntry>(3);
            } else {
                entryList.remove(existingDNSEntry);
            }
            entryList.add(newDNSEntry);
            this.put(key, entryList);
            boolean bl = true;
            return bl;
        }
    }

    private List<DNSEntry> getEntryListOrEmpty(String key) {
        List entryList = (List)this.get(key);
        if (entryList == null) {
            return Collections.emptyList();
        }
        return entryList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("\n\t---- cache ----");
        for (Map.Entry entry : this.entrySet()) {
            sb.append("\n\n\t\tname '").append((String)entry.getKey()).append('\'');
            List entryList = (List)entry.getValue();
            if (entryList == null) continue;
            String key = (String)entry.getKey();
            SimpleLockManager.Locked lock = this._lm.lock(key);
            Throwable throwable = null;
            try {
                if (entryList.isEmpty()) {
                    sb.append(" : no entries");
                    continue;
                }
                for (DNSEntry dnsEntry : entryList) {
                    sb.append("\n\t\t\t").append(dnsEntry.toString());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
        return sb.toString();
    }

    public void logCachedContent() {
        if (!this.logger.isTraceEnabled()) {
            return;
        }
        this.logger.trace("Cached DNSEntries: {}", (Object)this);
    }
}

