# Spec_An_128Hz_AMIGA.py
# Pure text mode, UNCALIBRATED, LOG10(x) scaled, AF Spectrum Analyser DEMO.
# A fun test piece for a default [77/]80 columns x 24 lines Terminal/CLI.
# There is extensive use of terminal escape codes too. 

# Designed to primarily work on a highly expanded AMIGA A1200(HD), OS3.0x, using Python 2.0.x.
# The maximum AMIGA terminal size is 77 columns x 24 lines minimum, in PAL mode.
# It only needs a 4 colour minimum default Workbench for it to work.
# Run the code from the command line as normal, but expect it to take several minutes to finish!

# Author: Barry Walker, G0LCU...
# $VER (C)2025_B.Walker,_G0LCU,_Spec_An_128Hz_AMIGA.py_Version_1.00.00;_issued as CC0 Licence,_Public_Domain.
# As of 01-09-2025, this works on all Versions of Python from 2.0.x to 3.13.x, without ANY modification.
# An ASCII text mode DEMO to show how to get a pseudo[-]logarithmic display inside a default terminal.

# Reset the Terminal and clear the screen.
print("\033c\033[2J\033[H")

import sys
import cmath

# This is the recursive FFT function that works on Python 2.0.1 minimum for
# the AMIGA A1200(HD), to Version 3.13.x, without modification...
# Not tested on Python 3.14.x as yet, but making the assumption that it works!
def fft(DATA):
	N=len(DATA)
	if N<=1: return(DATA)
	EVEN=fft([DATA[K] for K in range(0,N,2)])
	ODD=fft([DATA[K] for K in range(1,N,2)])
	return([EVEN[K]+cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))]+[EVEN[K]-cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))])

# Ensure the top left hand corner!
print("\033[2J\033[H    100-+\033[1;33m+---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++\033[0m.")
print("  U     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  N  90-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  C     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  A  80-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  L     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  I  70-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  B     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  R  60-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  A     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  T  50-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  E     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  D  40-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("        ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  ^  30-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("        ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  L  20-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print("  O     ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("  G  10-++---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++|")
print(" (y)    ||         |     |   |  |  | | | ||         |     |   |  |  | | | |||")
print("      0-+\033[1;33m+---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++\033[0m|")
print("LOG10(x)>+---------+-----+---+--+--+-+-+-++---------+-----+---+--+--+-+-+-++'")
print("        100       200       400  FREQ 800 1K HERTZ  2K        4K       8K 10K")

# Create 128 cycles of a 128Hz square wave.
array_list=[]
for n in range(0,128):
	x=1.0
	for m in range(0,64):
		array_list.append(x)
	x=0.0
	for m in range(0,64):
		array_list.append(x)

# Create a[n] FFT list without numpy, scipy, or simpy, the Classic AMIGA doesn't have them.
FFT=fft(array_list)

multiplierX=33.4
multiplierY=2.46

# Create an integer range for relative amplitude in text mode.
for n in range(0,16384):
	FFT[n]=int(abs(multiplierY*cmath.log(1+FFT[n])))

# Plot amplitude relative values only, totally UNcalibrated.
for n in range(100,8192):
	X_AXIS=int(abs(multiplierX*cmath.log10(n))-57)
	if FFT[n]>0:
		# Invert the value to display correctly in the terminal......
		PEAK=(22-FFT[n])
		# ......and ensure boundaries are not exceeded.
		if PEAK<1: PEAK=1
		if PEAK>21: PEAK=21
		# And finally plot it.
		for Y_AXIS in range(PEAK,22):
			print("\033[1;32m\033["+str(Y_AXIS)+";"+str(X_AXIS)+"f*\033[0m\033[23;0f")

sys.exit(0)

