#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import datetime

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("presents the time")

    def run(self):
        time_format = self.env["runtime"]["SettingsManager"].get_setting(
            "general", "time_format"
        )

        # get the time formatted
        time_string = datetime.datetime.strftime(
            datetime.datetime.now(), time_format
        )

        # present the time via speak and braile, there is no soundicon,
        # interrupt the current speech
        self.env["runtime"]["OutputManager"].present_text(
            time_string, sound_icon="", interrupt=True
        )

    def set_callback(self, callback):
        pass
