/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -i --recursive-functions
#include <stdint.h>
#include <limits.h>
#include <assert.h>

static const uint64_t ERROR = ~0lu;

struct State
{
    const char* cur;
    const char* mar;
    uint64_t num;
};

template<int BASE> static void adddgt(uint64_t &u, unsigned int d)
{
    u = u * BASE + d;
    if (u > UINT32_MAX) u = ERROR;
}




uint64_t yy0(State& st);
uint64_t yy1(State& st);
uint64_t yy2(State& st);
uint64_t yy3(State& st);
uint64_t lex_bin(State& st);

uint64_t yy0(State& st) {
	char yych = *st.cur++;
	switch (yych) {
		case 0x00: return yy1(st);
		case '0':
		case '1': return yy3(st);
		default: return yy2(st);
	}
}

uint64_t yy1(State& st) {
	return st.num;
}

uint64_t yy2(State& st) {
	return ERROR;
}

uint64_t yy3(State& st) {
	adddgt<2>(st.num, st.cur[-1] - '0'); return lex_bin(st);
}

uint64_t lex_bin(State& st) {
	return yy0(st);
}




uint64_t yy4(State& st);
uint64_t yy5(State& st);
uint64_t yy6(State& st);
uint64_t yy7(State& st);
uint64_t lex_oct(State& st);

uint64_t yy4(State& st) {
	char yych = *st.cur++;
	switch (yych) {
		case 0x00: return yy5(st);
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': return yy7(st);
		default: return yy6(st);
	}
}

uint64_t yy5(State& st) {
	return st.num;
}

uint64_t yy6(State& st) {
	return ERROR;
}

uint64_t yy7(State& st) {
	adddgt<8>(st.num, st.cur[-1] - '0'); return lex_oct(st);
}

uint64_t lex_oct(State& st) {
	return yy4(st);
}




uint64_t yy8(State& st);
uint64_t yy9(State& st);
uint64_t yy10(State& st);
uint64_t yy11(State& st);
uint64_t lex_dec(State& st);

uint64_t yy8(State& st) {
	char yych = *st.cur++;
	switch (yych) {
		case 0x00: return yy9(st);
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': return yy11(st);
		default: return yy10(st);
	}
}

uint64_t yy9(State& st) {
	return st.num;
}

uint64_t yy10(State& st) {
	return ERROR;
}

uint64_t yy11(State& st) {
	adddgt<10>(st.num, st.cur[-1] - '0'); return lex_dec(st);
}

uint64_t lex_dec(State& st) {
	return yy8(st);
}




uint64_t yy12(State& st);
uint64_t yy13(State& st);
uint64_t yy14(State& st);
uint64_t yy15(State& st);
uint64_t yy16(State& st);
uint64_t yy17(State& st);
uint64_t lex_hex(State& st);

uint64_t yy12(State& st) {
	char yych = *st.cur++;
	switch (yych) {
		case 0x00: return yy13(st);
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': return yy15(st);
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F': return yy16(st);
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': return yy17(st);
		default: return yy14(st);
	}
}

uint64_t yy13(State& st) {
	return st.num;
}

uint64_t yy14(State& st) {
	return ERROR;
}

uint64_t yy15(State& st) {
	adddgt<16>(st.num, st.cur[-1] - '0');      return lex_hex(st);
}

uint64_t yy16(State& st) {
	adddgt<16>(st.num, st.cur[-1] - 'A' + 10); return lex_hex(st);
}

uint64_t yy17(State& st) {
	adddgt<16>(st.num, st.cur[-1] - 'a' + 10); return lex_hex(st);
}

uint64_t lex_hex(State& st) {
	return yy12(st);
}




uint64_t yy18(State& st);
uint64_t yy19(State& st);
uint64_t yy20(State& st);
uint64_t yy21(State& st);
uint64_t yy22(State& st);
uint64_t yy23(State& st);
uint64_t yy24(State& st);
uint64_t yy25(State& st);
uint64_t yy26(State& st);
uint64_t yy27(State& st);
uint64_t lex_main(State& st);

uint64_t yy18(State& st) {
	char yych = *st.cur++;
	switch (yych) {
		case '0': return yy20(st);
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': return yy22(st);
		default: return yy19(st);
	}
}

uint64_t yy19(State& st) {
	return ERROR;
}

uint64_t yy20(State& st) {
	char yych = *(st.mar = st.cur);
	switch (yych) {
		case 'B':
		case 'b':
			++st.cur;
			return yy23(st);
		case 'X':
		case 'x':
			++st.cur;
			return yy25(st);
		default: return yy21(st);
	}
}

uint64_t yy21(State& st) {
	return lex_oct(st);
}

uint64_t yy22(State& st) {
	st.cur -= 1;
	return lex_dec(st);
}

uint64_t yy23(State& st) {
	char yych = *st.cur;
	switch (yych) {
		case '0':
		case '1':
			++st.cur;
			return yy26(st);
		default: return yy24(st);
	}
}

uint64_t yy24(State& st) {
	st.cur = st.mar;
	return yy21(st);
}

uint64_t yy25(State& st) {
	char yych = *st.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
			++st.cur;
			return yy27(st);
		default: return yy24(st);
	}
}

uint64_t yy26(State& st) {
	st.cur -= 1;
	return lex_bin(st);
}

uint64_t yy27(State& st) {
	st.cur -= 1;
	return lex_hex(st);
}

uint64_t lex_main(State& st) {
	return yy18(st);
}



static uint64_t parse_u32(const char *s)
{
    State st = {s, nullptr, 0};
    return lex_main(st);
}

int main()
{
    assert(parse_u32("1234567890") == 1234567890);
    assert(parse_u32("0b1101") == 13);
    assert(parse_u32("0x7Fe") == 2046);
    assert(parse_u32("0644") == 420);
    assert(parse_u32("9999999999") == ERROR);
    assert(parse_u32("") == ERROR);
    return 0;
}
