# Copyright 1999-2024 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_NAME="tdeaddons"
TRINITY_MODULE_TYPE="core"
TRINITY_HANDBOOK="optional"
inherit cmake trinity-meta-2

DESCRIPTION="Various basic tdefile plugins provided by tdeaddons"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="+ssl"

DEPEND="
	~trinity-base/tdelibs-${PV}[ssl?]
"
RDEPEND="${DEPEND}"

src_prepare() {
	if ! use ssl; then
		pushd tdefile-plugins/ || die
		cmake_comment_add_subdirectory cert
		popd || die
	fi

	trinity-meta-2_src_prepare
}
