# Copyright 2022-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_HANDBOOK="optional"
TRINITY_MODULE_TYPE="applications/system"
inherit trinity-base-2

DESCRIPTION="DBUS notification service for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

DEPEND="
	dev-libs/dbus-glib
	sys-apps/dbus
	x11-libs/gtk+:2
"
RDEPEND="$DEPEND"
BDEPEND="dev-libs/dbus-glib"

src_configure() {
	local mycmakeargs=(
		-DDBUS_BINDING_TOOL="$BROOT/usr/bin/dbus-binding-tool"
	)

	trinity-base-2_src_configure
}
