# Copyright 1999-2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="optional"

TRINITY_LANGS="de el es fi fr hu it nl pl sv tr"
TRINITY_MODULE_TYPE="applications/utilities"
inherit trinity-base-2 optfeature

DESCRIPTION="Barcode and label printing application for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi

IUSE="javascript libbarcode"

DEPEND="
	libbarcode? ( >=app-text/barcode-0.99-r2 )
	dev-libs/libpcre2
"
RDEPEND="${DEPEND}
	virtual/imagemagick-tools
	!libbarcode? (
		|| (
			app-text/barcode
			app-text/ghostscript-gpl
		)
	)
"

PATCHES=(
	"${FILESDIR}/${P}-Fix-build-WITH_NATIVE_GNU_BARCODE-enabled.patch"
)

src_configure() {
	local mycmakeargs=(
		-DBUILD_TRANSLATIONS=ON
		-DWITH_NATIVE_GNU_BARCODE="$(usex libbarcode)"
		-DWITH_JAVASCRIPT="$(usex javascript)"
	)

	trinity-base-2_src_configure
}

pkg_postinst() {
	optfeature "additional barcode formats" app-text/barcode
	optfeature "additional barcode formats" app-text/ghostscript-gpl

	# currently not in portage
	# optfeature "additional barcode formats" app-text/tbarcode
	# optfeature "pdf417 barcode format" app-text/pdf417_encode
}
