package CannonField;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);
use TQt::signals
	angleChanged => ['int'];
use TQt::slots
	setAngle => ['int'];
use TQt::attributes qw(
	ang
);
use POSIX qw(atan);

sub angle () { ang }

sub NEW {
    shift->SUPER::NEW(@_);

    ang = 45;
    setPalette(TQt::Palette(TQt::Color(250, 250, 200)));
}

sub setAngle {
    my $degrees = shift;
    $degrees = 5 if $degrees < 5;
    $degrees = 70 if $degrees > 70;
    return if ang == $degrees;
    ang = $degrees;
    repaint();
    emit angleChanged(ang);
}

sub paintEvent {
    my $p = TQt::Painter(this);
    $p->setBrush(&blue);
    $p->setPen(&NoPen);

    $p->translate(0, rect()->bottom);
    $p->drawPie(TQt::Rect(-35, -35, 70, 70), 0, 90*16);
    $p->rotate(- ang);
    $p->drawRect(TQt::Rect(33, -4, 15, 8));
}

sub sizePolicy {
    TQt::SizePolicy(&TQt::SizePolicy::Expanding, &TQt::SizePolicy::Expanding);
}

1;
