package CannonField;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);
use TQt::signals
	angleChanged => ['int'];
use TQt::slots
	setAngle => ['int'];
use TQt::attributes qw(
	ang
);
use POSIX qw(atan);

sub angle () { ang }

sub NEW {
    shift->SUPER::NEW(@_);

    ang = 45;
    setPalette(TQt::Palette(TQt::Color(250, 250, 200)));
}

sub setAngle {
    my $degrees = shift;
    $degrees = 5 if $degrees < 5;
    $degrees = 70 if $degrees > 70;
    return if ang == $degrees;
    ang = $degrees;
    repaint();
    emit angleChanged(ang);
}

sub paintEvent {
    my $s = "Angle = " . ang;
    my $p = TQt::Painter(this);
    $p->drawText(200, 200, $s);
}

sub sizePolicy {
    TQt::SizePolicy(&TQt::SizePolicy::Expanding, &TQt::SizePolicy::Expanding);
}

1;
