=begin
  This class serves as the main window for %{APPNAME}.  It handles the
  menus, toolbars, and status bars.
 
  @short Main window class
  @author %{AUTHOR} <%{EMAIL}>
  @version %{VERSION}
=end

class %{APPNAMESC} < KDE::MainWindow

    slots 'fileNew()',
          'optionsPreferences()',
          'newToolbarConfig()',
          'changeStatusbar(const TQString&)',
          'changeCaption(const TQString&)'

    def initialize()
        super( nil, "%{APPNAMESC}" )
        Settings.instance.readConfig
        @view = %{APPNAMESC}View.new(self)
        @printer = nil

        # accept dnd
        setAcceptDrops(true)
    
        # tell the KDE::MainWindow that this is indeed the main widget
        setCentralWidget(@view)
    
        # then, setup our actions
        setupActions()
    
        # and a status bar
        statusBar().show()
    
        # Apply the create the main window and ask the mainwindow to
        # automatically save settings if changed: window size, toolbar
        # position, icon size, etc.  Also to add actions for the statusbar
        # toolbar, and keybindings if necessary.
        setupGUI();
    
        # allow the view to change the statusbar and caption
        connect(@view, TQ_SIGNAL('signalChangeStatusbar(const TQString&)'),
                self,   TQ_SLOT('changeStatusbar(const TQString&)'))
        connect(@view, TQ_SIGNAL('signalChangeCaption(const TQString&)'),
                self,   TQ_SLOT('changeCaption(const TQString&)'))
    
    end
    
    def setupActions()
        KDE::StdAction.openNew(self, TQ_SLOT('fileNew()'), actionCollection())
        KDE::StdAction.quit($kapp, TQ_SLOT('quit()'), actionCollection())

        KDE::StdAction.preferences(self, TQ_SLOT('optionsPreferences()'), actionCollection())
    
        # this doesn't do anything useful.  it's just here to illustrate
        # how to insert a custom menu and menu item
        custom = KDE::Action.new(i18n("Swi&tch Colors"), KDE::Shortcut.new(),
                                    @view, TQ_SLOT('switchColors()'),
                                    actionCollection(), "switch_action")
    end
    
    def fileNew()
        # This slot is called whenever the File.New menu is selected,
        # the New shortcut is pressed (usually CTRL+N) or the New toolbar
        # button is clicked
    
        # create a new window
        %{APPNAMESC}.new.show()
    end
    
    def optionsPreferences()
        # The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
        # 
        # compare the names of the widgets in the .ui file
        # to the names of the variables in the .kcfg file
        dialog = KDE::ConfigDialog.new(self, "settings", Settings.instance, KDE::DialogBase::Swallow)
        dialog.addPage(Prefs.new(), i18n("General"), "package_settings")
        connect(dialog, TQ_SIGNAL('settingsChanged()'), @view, TQ_SLOT('settingsChanged()'))
        dialog.show()

    end
    
    def changeStatusbar(text)
        # display the text on the statusbar
        statusBar().message(text)
    end
    
    def changeCaption(text)
        # display the text on the caption
        setCaption(text)
    end

end
