#ifndef ViewApplet_h
#define ViewApplet_h

#include "viewbase.h"
#include <kpanelapplet.h>

class TQBoxLayout;
class TQHBox;
class TQSize;

class Mixer;

class ViewApplet : public ViewBase
{
    TQ_OBJECT
  
public:
    ViewApplet(TQWidget* parent, const char* name, Mixer* mixer, ViewBase::ViewFlags vflags, KPanelApplet::Position pos);
    ~ViewApplet();

    virtual int count();
    virtual int advice();
    virtual void setMixSet(MixSet *mixset);
    virtual TQWidget* add(MixDevice *mdw);
    virtual void constructionFinished();
    virtual void configurationUpdate();

    TQSize       sizeHint() const;
    TQSizePolicy sizePolicy() const;
    virtual void resizeEvent(TQResizeEvent*);

signals:
    void appletContentChanged();

public slots:
   virtual void refreshVolumeLevels();

private:
    bool shouldShowIcons(TQSize);
    TQBoxLayout*   _layoutMDW;
    // Position of the applet (pLeft, pRight, pTop, pBottom)
    //KPanelApplet::Position  _KMIXposition;
    // Orientation of the applet (horizontal or vertical)
    TQt::Orientation _viewOrientation;
};

#endif

