	/*

	Copyright (C) 1998-2001 Stefan Westerfeld
                            stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "interfacedlg.h"
#include "structureport.h"
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <kbuttonbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kseparator.h>
#include <tdelocale.h>
#include <tqlineedit.h>
#include <stdio.h>
#include <arts/debug.h>
#include <arts/core.h>
#include <arts/dispatcher.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

using namespace std;

InterfaceDlg::InterfaceDlg(TQWidget *parent) :TQDialog(parent,"Props", true)
{
	setCaption(i18n("aRts: Structureport View"));

	TQVBoxLayout *mainlayout = new TQVBoxLayout(this);
	//TQHBoxLayout *contentslayout = new TQHBoxLayout;

// object type
/*
	mainlayout->addSpacing(5);
	TQLabel *objectlabel = new TQLabel(this);
	TQFont labelfont(objectlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	objectlabel->setFont(labelfont);
	objectlabel->setText(TQString(" ")+i18n("Object type: ")+TQString(port->owner->name())+TQString(" "));
	objectlabel->setAlignment(AlignCenter);
	min_size(objectlabel);
	mainlayout->addWidget(objectlabel);
*/

// port description

/*
	mainlayout->addSpacing(5);
	TQLabel *portlabel = new TQLabel(this);
	labelfont.setPointSize(labelfont.pointSize()*4/5);
	portlabel->setFont(labelfont);
	portlabel->setText(i18n("Port description: ")+ port->description);
	min_size(portlabel);
	portlabel->setAlignment(AlignCenter);
	mainlayout->addWidget(portlabel);

	int labelwidth = imax(portlabel->sizeHint().width(),objectlabel->sizeHint().width());

	portlabel->setMinimumWidth(labelwidth);
	objectlabel->setMinimumWidth(labelwidth);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler);
	mainlayout->addSpacing(5);
	mainlayout->addLayout(contentslayout);
*/
// list

	listbox = new TQListBox(this);

	update();

	listbox->setMinimumSize(340,400);
	mainlayout->addWidget(listbox);
        connect( listbox, TQ_SIGNAL( doubleClicked ( TQListBoxItem *)), this,
                 TQ_SLOT(accept()));
// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler2);

// buttons

	TQHBoxLayout *buttonlayout = new TQHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), this, TQ_SLOT( help() ));
	bbox->addStretch(1);

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(accept() ) );

	TQButton *cancelbutton = bbox->addButton(KStdGuiItem::cancel());
	connect( cancelbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(reject() ) );

	bbox->layout();
	//min_size(bbox);

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	//mainlayout->activate();
	mainlayout->freeze();
}

string InterfaceDlg::interfaceName()
{
	if(listbox->currentItem() != -1)
	{
		string s = listbox->text(listbox->currentItem()).local8Bit().data();
		string::iterator j = s.begin();
		while(*j == ' ') j++;
			return string(j, s.end());
	}
	return "";
}

void InterfaceDlg::raise()
{
}

void InterfaceDlg::lower()
{
}

void InterfaceDlg::rename()
{
}

void InterfaceDlg::update(const string& interface, const string& indent)
{
	listbox->insertItem((indent + interface).c_str());

	vector<string> *children = Arts::Dispatcher::the()->interfaceRepo().queryChildren(interface);
	for (vector<string>::iterator ci = children->begin(); ci != children->end(); ++ci)
		update(ci->c_str(), indent+"  ");
	delete children;
}

void InterfaceDlg::update()
{
	update("Arts::Object", "");
}

void InterfaceDlg::help()
{
	TDEApplication::kApplication()->invokeHelp("", "karts");
}

#include "interfacedlg.moc"
